/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.Indexer;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.ispn.ChangesKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIndexerCacheStore
extends AbstractCacheStore {
    protected final Map<String, Indexer> indexers = new HashMap<String, Indexer>();
    protected static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexerCacheLoader");

    public void register(SearchManager searchManager, SearchManager parentSearchManager, QueryHandler handler, QueryHandler parentHandler) throws RepositoryConfigurationException {
        this.indexers.put(searchManager.getWsId(), new Indexer(searchManager, parentSearchManager, handler, parentHandler));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Register " + searchManager.getWsId() + " " + (Object)((Object)this) + " in " + this.indexers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store(InternalCacheEntry entry) throws CacheLoaderException {
        if (!(entry.getKey() instanceof ChangesKey) || !(entry.getValue() instanceof ChangesFilterListsWrapper)) return;
        if (log.isDebugEnabled()) {
            log.info((Object)"Received list wrapper, start indexing...");
        }
        ChangesFilterListsWrapper wrapper = (ChangesFilterListsWrapper)entry.getValue();
        ChangesKey key = (ChangesKey)entry.getKey();
        try {
            Indexer indexer = this.indexers.get(key.getWsId());
            if (indexer == null) {
                log.warn((Object)("No indexer could be found for the cache entry " + key.toString()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The current content of the map of indexers is " + this.indexers));
                }
            } else if (wrapper.withChanges()) {
                indexer.updateIndex(wrapper.getChanges(), wrapper.getParentChanges());
            } else {
                indexer.updateIndex(wrapper.getAddedNodes(), wrapper.getRemovedNodes(), wrapper.getParentAddedNodes(), wrapper.getParentRemovedNodes());
            }
            Object var6_5 = null;
            if (this.getModeHandler().getMode() != IndexerIoMode.READ_WRITE) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.getModeHandler().getMode() != IndexerIoMode.READ_WRITE) throw throwable;
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LOCKING});
            this.cache.removeAsync((Object)key);
            throw throwable;
        }
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LOCKING});
        this.cache.removeAsync((Object)key);
    }

    public abstract IndexerIoModeHandler getModeHandler();

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return AbstractCacheStoreConfig.class;
    }

    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        throw new UnsupportedOperationException("This operation is not supported by this component.");
    }

    public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
        throw new UnsupportedOperationException("This operation is not supported by this component.");
    }

    protected void purgeInternal() throws CacheLoaderException {
    }

    public void clear() throws CacheLoaderException {
        throw new UnsupportedOperationException("This operation is not supported by this component.");
    }

    public boolean remove(Object key) throws CacheLoaderException {
        return true;
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        return null;
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        return null;
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return null;
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        return null;
    }
}

