/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.StringHelper;

public abstract class CollectionAction
implements Executable,
Serializable,
Comparable {
    private transient CollectionPersister persister;
    private final Serializable key;
    private Serializable finalKey;
    private final SessionImplementor session;
    private SoftLock lock;
    private final String collectionRole;
    private final PersistentCollection collection;

    public CollectionAction(CollectionPersister persister, PersistentCollection collection, Serializable key, SessionImplementor session) throws CacheException {
        this.persister = persister;
        this.session = session;
        this.key = key;
        this.collectionRole = persister.getRole();
        this.collection = collection;
    }

    protected PersistentCollection getCollection() {
        return this.collection;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.persister = this.session.getFactory().getCollectionPersister(this.collectionRole);
    }

    public void afterTransactionCompletion(boolean success) throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey ck = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode(), this.session.getFactory());
            this.persister.getCacheAccessStrategy().unlockItem(ck, this.lock);
        }
    }

    public boolean hasAfterTransactionCompletion() {
        return this.persister.hasCache();
    }

    public Serializable[] getPropertySpaces() {
        return this.persister.getCollectionSpaces();
    }

    protected final CollectionPersister getPersister() {
        return this.persister;
    }

    protected final Serializable getKey() {
        this.finalKey = this.key;
        if (this.key instanceof DelayedPostInsertIdentifier) {
            this.finalKey = this.session.getPersistenceContext().getEntry(this.collection.getOwner()).getId();
            if (this.finalKey == this.key) {
                // empty if block
            }
        }
        return this.finalKey;
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    public final void beforeExecutions() throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey ck = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode(), this.session.getFactory());
            this.lock = this.persister.getCacheAccessStrategy().lockItem(ck, null);
        }
    }

    protected final void evict() throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey ck = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode(), this.session.getFactory());
            this.persister.getCacheAccessStrategy().remove(ck);
        }
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.collectionRole, this.key);
    }

    public int compareTo(Object other) {
        CollectionAction action = (CollectionAction)other;
        int roleComparison = this.collectionRole.compareTo(action.collectionRole);
        if (roleComparison != 0) {
            return roleComparison;
        }
        return this.persister.getKeyType().compare(this.key, action.key, this.session.getEntityMode());
    }
}

