/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.JsOptimizer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Statement;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import java.util.Collections;

public class JsOptimizerTest
extends CajaTestCase {
    JsOptimizer opt;

    public void setUp() throws Exception {
        super.setUp();
        this.opt = new JsOptimizer(this.mq);
        this.opt.setRename(true);
        this.opt.setEnvJson(new ObjectConstructor(FilePosition.UNKNOWN));
    }

    public final void testOptimizeNothing() {
        this.assertOptimized(JsOptimizerTest.emptyProgram(), new Block[0]);
    }

    public final void testSideEffectFreeStmtsEliminated() throws Exception {
        this.assertOptimized(JsOptimizerTest.emptyProgram(), this.js(this.fromString("+4;")));
    }

    public final void testVoidNotChanged() throws Exception {
        this.assertOptimized(this.js(this.fromString("foo;")), this.js(this.fromString("void foo;")));
    }

    public final void testRenaming1() throws Exception {
        this.assertOptimized(this.js(this.fromString("function quotient(a, b) { return a / b; }")), this.js(this.fromString("function quotient(dividend, divisor) { return dividend/divisor; }")));
    }

    public final void testRenaming2() throws Exception {
        this.opt.setRename(false);
        this.assertOptimized(this.js(this.fromString("function quotient(dividend, divisor) { return dividend/divisor; }")), this.js(this.fromString("function quotient(dividend, divisor) { return dividend/divisor; }")));
    }

    public final void testFolding() throws Exception {
        this.assertOptimized(this.js(this.fromString("alert(2);")), this.js(this.fromString("alert(1+1);")));
    }

    public final void testMultiple() throws Exception {
        this.assertOptimized(this.js(this.fromString("alert(a?(foo(),bar(),baz()):boo())")), this.js(this.fromString("alert(function(){ if (a) { foo(); bar(); return baz(); }else return boo(); }());")));
    }

    private void assertOptimized(Statement golden, Block ... inputs) {
        for (Block input : inputs) {
            this.opt.addInput(input);
        }
        Statement optimized = this.opt.optimize();
        JsOptimizerTest.assertEquals((String)JsOptimizerTest.renderProgram(golden), (String)JsOptimizerTest.renderProgram(optimized));
    }

    private static Block emptyProgram() {
        return new Block(FilePosition.UNKNOWN, Collections.emptyList());
    }

    private static String renderProgram(Statement s) {
        StringBuilder out = new StringBuilder();
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(out)));
        if (s instanceof Block) {
            ((Block)s).renderBody(rc);
        } else {
            s.render(rc);
        }
        rc.getOut().noMoreTokens();
        return out.toString();
    }
}

