/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Serialized
public class UIFormStringInput
extends UIFormInputBase<String> {
    public static final short TEXT_TYPE = 0;
    public static final short PASSWORD_TYPE = 1;
    private short type_ = 0;
    private int maxLength = 0;

    public UIFormStringInput() {
    }

    public UIFormStringInput(String name, String bindingExpression, String value) {
        super(name, bindingExpression, String.class);
        this.value_ = value;
    }

    public UIFormStringInput(String name, String value) {
        this(name, null, value);
    }

    public UIFormStringInput setType(short type) {
        this.type_ = type;
        return this;
    }

    public UIFormStringInput setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        String val = (String)input;
        if ((val == null || val.length() == 0) && this.type_ == 1) {
            return;
        }
        this.value_ = val;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        w.write("<input name='");
        w.write(this.getName());
        w.write(39);
        if (this.type_ == 1) {
            w.write(" type='password'");
        } else {
            w.write(" type='text'");
        }
        w.write(" id='");
        w.write(this.getId());
        w.write(39);
        if (this.value_ != null && ((String)this.value_).length() > 0) {
            w.write(" value='");
            w.write(this.encodeValue((String)this.value_).toString());
            w.write(39);
        }
        if (this.maxLength > 0) {
            w.write(" maxlength='" + this.maxLength + "'");
        }
        if (this.readonly_) {
            w.write(" readonly ");
        }
        if (!this.enable_) {
            w.write(" disabled ");
        }
        w.write("/>");
        if (this.isMandatory()) {
            w.write(" *");
        }
    }

    private StringBuilder encodeValue(String value) {
        char[] chars = new char[]{'\'', '\"'};
        String[] refs = new String[]{"&#39;", "&#34;"};
        StringBuilder builder = new StringBuilder(value);
        for (int i = 0; i < chars.length; ++i) {
            int idx = this.indexOf(builder, chars[i], 0);
            while (idx > -1) {
                builder = builder.replace(idx, idx + 1, refs[i]);
                idx = this.indexOf(builder, chars[i], idx);
            }
        }
        return builder;
    }

    private int indexOf(StringBuilder builder, char c, int from) {
        for (int i = from; i < builder.length(); ++i) {
            if (builder.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

