/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.chromattic.core.jcr.type.MixinTypeInfo;
import org.chromattic.core.jcr.type.NodeTypeInfo;
import org.chromattic.core.jcr.type.PrimaryTypeInfo;

public class TypeManager {
    private final Object nodeTypeInfosLock = new Object();
    private volatile Map<String, NodeTypeInfo> nodeTypeInfos = new HashMap<String, NodeTypeInfo>();

    public boolean isReferenceable(Node node) throws RepositoryException {
        for (NodeType nt : node.getMixinNodeTypes()) {
            if (!nt.getName().equals("mix:referenceable")) continue;
            return true;
        }
        PrimaryTypeInfo ntInfo = (PrimaryTypeInfo)this.getTypeInfo(node.getPrimaryNodeType());
        return ntInfo.getMixinNames().contains("mix:referenceable");
    }

    public PrimaryTypeInfo getPrimaryTypeInfo(NodeType primaryType) throws RepositoryException {
        return (PrimaryTypeInfo)this.getTypeInfo(primaryType);
    }

    public MixinTypeInfo getMixinTypeInfo(NodeType mixinType) throws RepositoryException {
        return (MixinTypeInfo)this.getTypeInfo(mixinType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeTypeInfo getTypeInfo(NodeType nodeType) {
        String nodeTypeName = nodeType.getName();
        NodeTypeInfo nodeTypeInfo = this.nodeTypeInfos.get(nodeTypeName);
        if (nodeTypeInfo == null) {
            if (nodeType.isMixin()) {
                nodeTypeInfo = new MixinTypeInfo(nodeType);
            } else {
                HashSet<NodeTypeInfo> superTypes = new HashSet<NodeTypeInfo>();
                for (NodeType superType : nodeType.getSupertypes()) {
                    NodeTypeInfo superTIs = this.getTypeInfo(superType);
                    superTypes.add(superTIs);
                }
                nodeTypeInfo = new PrimaryTypeInfo(nodeType, Collections.unmodifiableSet(superTypes));
            }
            Object object = this.nodeTypeInfosLock;
            synchronized (object) {
                HashMap<String, NodeTypeInfo> copy = new HashMap<String, NodeTypeInfo>(this.nodeTypeInfos);
                copy.put(nodeTypeName, nodeTypeInfo);
                this.nodeTypeInfos = copy;
            }
        }
        return nodeTypeInfo;
    }
}

