/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import org.gatein.common.io.Serialization;
import org.gatein.common.io.SerializationFilter;
import org.gatein.common.io.UndeclaredIOException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOTools {
    public static final Logger log = LoggerFactory.getLogger(IOTools.class);
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class<?>[] EMPTY_PARAMETER_TYPES = new Class[0];

    public static void safeClose(Object closable) {
        if (closable != null) {
            try {
                Method m = closable.getClass().getMethod("close", EMPTY_PARAMETER_TYPES);
                if (Modifier.isStatic(m.getModifiers())) {
                    log.warn((Object)"close() method on closable object is static");
                    return;
                }
                m.invoke(closable, EMPTY_ARGS);
            }
            catch (NoSuchMethodException e) {
                log.warn((Object)"The closable object does not have a close() method", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)"Cannot access close() method on closable object", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof RuntimeException) {
                    log.error((Object)"The close() method threw a runtime exception", t);
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    log.error((Object)"The close() method threw an error", t);
                    throw (Error)t;
                }
                if (t instanceof Exception) {
                    log.error((Object)"The close() method threw an exception", t);
                }
                log.error((Object)"The close() method threw an unexpected throwable", t);
            }
        }
    }

    public static void safeClose(Closeable out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                log.error((Object)("Error while closing closeable " + out), (Throwable)e);
            }
        }
    }

    public static byte[] getBytes(InputStream in) throws IOException, IllegalArgumentException {
        return IOTools.getBytes(in, 512);
    }

    public static byte[] getBytes(InputStream in, int bufferSize) throws IOException, IllegalArgumentException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOTools.copy(in, out, bufferSize);
        return out.toByteArray();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IOTools.copy(in, out, 512);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("null in");
        }
        if (out == null) {
            throw new IllegalArgumentException("null out");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size is too small");
        }
        byte[] buffer = new byte[bufferSize];
        while (true) {
            int i;
            if ((i = in.read(buffer)) == 0) {
                continue;
            }
            if (i == -1) break;
            out.write(buffer, 0, i);
        }
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        IOTools.copy(reader, writer, 512);
    }

    public static void copy(Reader reader, Writer writer, int bufferSize) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("null in");
        }
        if (writer == null) {
            throw new IllegalArgumentException("null out");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size is too small");
        }
        char[] buffer = new char[bufferSize];
        while (true) {
            int i;
            if ((i = reader.read(buffer)) == 0) {
                continue;
            }
            if (i == -1) break;
            writer.write(buffer, 0, i);
        }
    }

    public static <S extends Serializable> S clone(S serializable) throws IllegalArgumentException, IOException {
        try {
            return IOTools.clone(serializable, null);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Got a class not found exception for a class that was used", e);
        }
    }

    public static <S extends Serializable> S clone(S serializable, ClassLoader classLoader) throws IllegalArgumentException, IOException, ClassNotFoundException {
        if (serializable == null) {
            throw new IllegalArgumentException("Cannot clone null");
        }
        if (classLoader == null && serializable != null) {
            classLoader = serializable.getClass().getClassLoader();
        }
        return (S)IOTools.unserialize(IOTools.serialize(serializable), classLoader);
    }

    public static byte[] serialize(Serializable serializable) throws IllegalArgumentException, IOException {
        if (serializable == null) {
            throw new IllegalArgumentException("No null serializable accepted");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(serializable);
        oos.close();
        return baos.toByteArray();
    }

    public static Serializable unserialize(byte[] bytes) throws IllegalArgumentException, IOException, ClassNotFoundException {
        return IOTools.unserialize(bytes, null);
    }

    public static Serializable unserialize(byte[] bytes, final ClassLoader classLoader) throws IllegalArgumentException, IOException, ClassNotFoundException {
        if (bytes == null) {
            throw new IllegalArgumentException("No null serializable accepted");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                if (classLoader == null) {
                    return super.resolveClass(desc);
                }
                String className = desc.getName();
                return Class.forName(className, false, classLoader);
            }

            @Override
            protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
                if (classLoader == null) {
                    return super.resolveProxyClass(interfaces);
                }
                Class[] ifaceClasses = new Class[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    ifaceClasses[i] = classLoader.loadClass(interfaces[i]);
                }
                return Proxy.getProxyClass(classLoader, ifaceClasses);
            }
        };
        return (Serializable)ois.readObject();
    }

    public static <T> byte[] serialize(Serialization<T> serialization, T t) {
        return IOTools.serialize(serialization, SerializationFilter.TRIVIAL, t);
    }

    public static <T> byte[] serialize(Serialization<T> serialization, SerializationFilter filter, T t) {
        if (serialization == null) {
            throw new IllegalArgumentException();
        }
        if (t == null) {
            throw new IllegalArgumentException("No null object to serialize");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            filter.serialize(serialization, t, baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static <T> T unserialize(Serialization<T> serialization, byte[] bytes) {
        return IOTools.unserialize(serialization, SerializationFilter.TRIVIAL, bytes);
    }

    public static <T> T unserialize(Serialization<T> serialization, SerializationFilter filter, byte[] bytes) {
        if (serialization == null) {
            throw new IllegalArgumentException();
        }
        if (bytes == null) {
            throw new IllegalArgumentException("No null bytes to unserialize");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return filter.unserialize(serialization, bais);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static BufferedInputStream safeBufferedWrapper(InputStream in) {
        if (in != null) {
            if (in instanceof BufferedInputStream) {
                return (BufferedInputStream)in;
            }
            return new BufferedInputStream(in);
        }
        return null;
    }

    public static BufferedOutputStream safeBufferedWrapper(OutputStream out) {
        if (out != null) {
            if (out instanceof BufferedOutputStream) {
                return (BufferedOutputStream)out;
            }
            return new BufferedOutputStream(out);
        }
        return null;
    }
}

