/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.mgt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.cache.CacheManager;
import org.jsecurity.cache.CacheManagerAware;
import org.jsecurity.cache.ehcache.EhCacheManager;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.util.Destroyable;
import org.jsecurity.util.LifecycleUtils;

public abstract class CachingSecurityManager
implements SecurityManager,
Destroyable,
CacheManagerAware {
    private static final Log log = LogFactory.getLog(CachingSecurityManager.class);
    protected CacheManager cacheManager;

    public CachingSecurityManager() {
        this.ensureCacheManager();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.afterCacheManagerSet();
    }

    protected void ensureCacheManager() {
        CacheManager cm = this.getCacheManager();
        if (cm == null && (cm = this.createCacheManager()) != null) {
            this.setCacheManager(cm);
        }
    }

    protected void afterCacheManagerSet() {
    }

    protected CacheManager createCacheManager() {
        EhCacheManager manager;
        block3: {
            manager = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attempting to initialize default CacheManager using EhCache...");
            }
            try {
                EhCacheManager ehCacheManager = new EhCacheManager();
                ehCacheManager.init();
                manager = ehCacheManager;
            }
            catch (NoClassDefFoundError e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Ehcache was not found in the classpath. A default EhCacheManager cannot be created.");
            }
        }
        return manager;
    }

    public void destroy() {
        this.beforeCacheManagerDestroyed();
        this.destroyCacheManager();
    }

    protected void beforeCacheManagerDestroyed() {
    }

    protected void destroyCacheManager() {
        LifecycleUtils.destroy(this.getCacheManager());
    }
}

