/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.plugin.BrowserTestCase;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomitaTest
extends BrowserTestCase {
    public final void testDomitaCajita() {
        this.runBrowserTest("domita_test.html");
    }

    public final void testDomitaValija() {
        this.runBrowserTest("domita_test.html?valija=1");
    }

    @Override
    protected void driveBrowser(final WebDriver driver, String pageName) {
        DomitaTest.poll(10000, 200, new BrowserTestCase.Check(){

            public String toString() {
                return "startup";
            }

            public boolean run() {
                List readyElements = driver.findElements(By.xpath((String)"//*[@class='readytotest']"));
                return readyElements.size() != 0;
            }
        });
        DomitaTest.poll(10000, 1000, new BrowserTestCase.Check(){
            private List<WebElement> clickingList = null;

            public String toString() {
                return "clicking done (Remaining elements = " + DomitaTest.renderElements(this.clickingList) + ")";
            }

            public boolean run() {
                this.clickingList = driver.findElements(By.xpath((String)"//*[contains(@class,'clickme')]/*"));
                for (WebElement e : this.clickingList) {
                    e.click();
                }
                return this.clickingList.isEmpty();
            }
        });
        DomitaTest.poll(10000, 1000, new BrowserTestCase.Check(){
            private List<WebElement> waitingList = null;

            public String toString() {
                return "completion (Remaining elements = " + DomitaTest.renderElements(this.waitingList) + ")";
            }

            public boolean run() {
                this.waitingList = driver.findElements(By.xpath((String)"//*[contains(@class,'waiting')]"));
                return this.waitingList.isEmpty();
            }
        });
        String title = driver.getTitle();
        DomitaTest.assertTrue((String)("The title shows " + title), (boolean)title.contains("all tests passed"));
    }

    private static String renderElements(List<WebElement> elements) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            String className;
            if (i != 0) {
                sb.append(", ");
            }
            WebElement el = elements.get(i);
            sb.append('<').append(el.getTagName());
            String id = el.getAttribute("id");
            if (id != null) {
                sb.append(" id=\"");
                Escaping.escapeXml((CharSequence)id, false, sb);
                sb.append('\"');
            }
            if ((className = el.getAttribute("class")) != null) {
                sb.append(" class=\"");
                Escaping.escapeXml((CharSequence)className, false, sb);
                sb.append('\"');
            }
            sb.append('>');
        }
        sb.append(']');
        return sb.toString();
    }
}

