/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import org.exoplatform.portal.config.UserACL;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputContainer;
import org.exoplatform.webui.form.UIFormPopupWindow;
import org.exoplatform.webui.form.validator.Validator;
import org.exoplatform.webui.organization.UIGroupMembershipSelector;
import org.exoplatform.webui.organization.UIListPermissionSelector;
import org.exoplatform.webui.organization.UISelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/organization/webui/component/UIPermissionSelector.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={UISelector.SelectMembershipActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={DeletePermissionActionListener.class})})
public class UIPermissionSelector
extends UISelector<String> {
    private UserACL.Permission permission_;
    private boolean isEditable = true;

    public UIPermissionSelector() throws Exception {
        super(null, null);
        UIFormPopupWindow uiPopup = (UIFormPopupWindow)this.addChild(UIFormPopupWindow.class, null, "PopupPermissionSelector");
        uiPopup.setWindowSize(540, 0);
        UIGroupMembershipSelector uiMembershipSelector = (UIGroupMembershipSelector)this.createUIComponent(UIGroupMembershipSelector.class, null, "SelectEditPermission");
        uiPopup.setUIComponent((UIComponent)uiMembershipSelector);
        uiMembershipSelector.setId("PermissionSelector");
        ((UITree)uiMembershipSelector.getChild(UITree.class)).setId("TreePermissionSelector");
        ((UIBreadcumbs)uiMembershipSelector.getChild(UIBreadcumbs.class)).setId("BreadcumbsPermissionSelector");
        this.permission_ = new UserACL.Permission();
    }

    public void configure(String iname, String bfield) {
        this.setName(iname);
        this.setBindingField(bfield);
    }

    public UIPermissionSelector setValue(String exp) {
        this.permission_ = new UserACL.Permission();
        this.permission_.setPermissionExpression(exp);
        return this;
    }

    public Class<String> getTypeValue() {
        return String.class;
    }

    public UserACL.Permission getPermission() {
        return this.permission_;
    }

    public String getValue() {
        return this.permission_.getExpression();
    }

    @Override
    void setMembership(String groupId, String membershipType) {
        if (this.permission_ == null) {
            return;
        }
        this.permission_.setGroupId(groupId);
        this.permission_.setMembership(membershipType);
        this.permission_.setExpression(membershipType + ":" + groupId);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public static class MandatoryValidator
    implements Validator {
        public void validate(UIFormInput uiInput) throws Exception {
            UIFormInputContainer uiInputContainer = (UIFormInputContainer)uiInput;
            String value = (String)uiInputContainer.getValue();
            if (value == null || value.trim().length() < 1) {
                Object[] args = new String[]{"UITabPane.title.UIPermissionSelector"};
                throw new MessageException(new ApplicationMessage("MandatoryValidatorIterator.msg.empty", args, 2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeletePermissionActionListener
    extends EventListener<UIPermissionSelector> {
        public void execute(Event<UIPermissionSelector> event) throws Exception {
            UIPermissionSelector uiPermissionSelector = (UIPermissionSelector)((Object)event.getSource());
            uiPermissionSelector.setValue(null);
            uiPermissionSelector.setRendered(true);
            UIForm uiForm = (UIForm)uiPermissionSelector.getAncestorOfType(UIForm.class);
            ((UIListPermissionSelector)uiForm.findFirstComponentOfType(UIListPermissionSelector.class)).setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

