/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.ws.rs.core.Response;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.command.dasl.SearchRequestEntity;
import org.exoplatform.services.jcr.webdav.command.dasl.SearchResultResponseEntity;
import org.exoplatform.services.jcr.webdav.command.dasl.UnsupportedQueryException;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SearchCommand {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.SearchCommand");

    public Response search(Session session, HierarchicalProperty body, String baseURI) {
        try {
            SearchRequestEntity requestEntity = new SearchRequestEntity(body);
            Query query = session.getWorkspace().getQueryManager().createQuery(requestEntity.getQuery(), requestEntity.getQueryLanguage());
            QueryResult queryResult = query.execute();
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            SearchResultResponseEntity searchResult = new SearchResultResponseEntity(queryResult, nsContext, baseURI);
            return Response.status((int)207).entity((Object)searchResult).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (UnsupportedQueryException exc) {
            return Response.status((int)400).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }
}

