/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import java.io.IOException;
import java.io.StringWriter;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.shindig.gadgets.parse.SocialDataTags;
import org.cyberneko.html.HTMLElements;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultHtmlSerializer
implements HtmlSerializer {
    public String serialize(Document doc) {
        try {
            StringWriter sw = HtmlSerialization.createWriter(doc);
            if (doc.getDoctype() != null) {
                this.outputDocType(doc.getDoctype(), sw);
            }
            this.serialize(doc, sw);
            return sw.toString();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public void serialize(Node n, Appendable output) throws IOException {
        this.serialize(n, output, false);
    }

    private void serialize(Node n, Appendable output, boolean xmlMode) throws IOException {
        if (n == null) {
            return;
        }
        switch (n.getNodeType()) {
            case 4: {
                break;
            }
            case 8: {
                this.writeComment(n, output);
                break;
            }
            case 9: {
                NodeList children = ((Document)n).getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    this.serialize(children.item(i), output, xmlMode);
                }
                break;
            }
            case 1: {
                Element elem = (Element)n;
                NodeList children = elem.getChildNodes();
                elem = this.substituteElement(elem);
                HTMLElements.Element htmlElement = HTMLElements.getElement((String)elem.getNodeName());
                DefaultHtmlSerializer.printStartElement(elem, output, xmlMode && htmlElement.isEmpty());
                boolean childXmlMode = xmlMode || htmlElement.isSpecial();
                for (int i = 0; i < children.getLength(); ++i) {
                    this.serialize(children.item(i), output, childXmlMode);
                }
                if (htmlElement.isEmpty()) break;
                output.append("</").append(elem.getNodeName()).append('>');
                break;
            }
            case 5: {
                output.append("&").append(n.getNodeName()).append(";");
                break;
            }
            case 3: {
                this.writeText(n, output);
            }
        }
    }

    private Element substituteElement(Element elem) {
        String scriptType = (String)SocialDataTags.SCRIPT_TYPE_TO_OSML_TAG.inverse().get((Object)elem.getNodeName());
        if (scriptType != null) {
            Element replacement = elem.getOwnerDocument().createElement("script");
            replacement.setAttribute("type", scriptType);
            NamedNodeMap attribs = elem.getAttributes();
            for (int i = 0; i < attribs.getLength(); ++i) {
                Attr attr = (Attr)attribs.item(i);
                if (attr.getNodeName().equalsIgnoreCase("type")) continue;
                Attr newAttr = replacement.getOwnerDocument().createAttribute(attr.getNodeName());
                newAttr.setValue(attr.getValue());
                replacement.setAttributeNode(newAttr);
            }
            return replacement;
        }
        return elem;
    }

    protected void writeText(Node n, Appendable output) throws IOException {
        output.append(n.getTextContent());
    }

    protected void writeComment(Node n, Appendable output) throws IOException {
        output.append("<!--").append(n.getNodeValue()).append("-->");
    }

    private void outputDocType(DocumentType docType, Appendable output) throws IOException {
        output.append("<!DOCTYPE ");
        output.append(docType.getOwnerDocument().getDocumentElement().getNodeName());
        if (docType.getPublicId() != null && docType.getPublicId().length() > 0) {
            output.append(" ");
            output.append("PUBLIC ").append('\"').append(docType.getPublicId()).append('\"');
        }
        if (docType.getSystemId() != null && docType.getSystemId().length() > 0) {
            output.append(" ");
            output.append('\"').append(docType.getSystemId()).append('\"');
        }
        output.append(">\n");
    }

    private static void printStartElement(Element elem, Appendable output, boolean withXmlClose) throws IOException {
        output.append("<").append(elem.getTagName());
        NamedNodeMap attributes = elem.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String attrName = attr.getNodeName();
            output.append(' ').append(attrName);
            if (attr.getNodeValue() == null) continue;
            output.append("=\"");
            if (attr.getNodeValue().length() != 0) {
                DefaultHtmlSerializer.printAttributeValue(attr.getNodeValue(), output);
            }
            output.append('\"');
        }
        output.append(withXmlClose ? "/>" : ">");
    }

    private static void printAttributeValue(String text, Appendable output) throws IOException {
        int length = text.length();
        for (int j = 0; j < length; ++j) {
            char c = text.charAt(j);
            if (c == '\"') {
                output.append("&quot;");
                continue;
            }
            if (c == '&') {
                output.append("&amp;");
                continue;
            }
            output.append(c);
        }
    }
}

