/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BaseTagRemoverRewriter
implements GadgetRewriter,
ResponseRewriter {
    private static final Logger logger = Logger.getLogger(BaseTagRemoverRewriter.class.getName());

    public void rewrite(Gadget gadget, MutableContent mc) {
        Document doc = mc.getDocument();
        NodeList list = doc.getElementsByTagName("base");
        for (int i = 0; i < list.getLength(); ++i) {
            Element baseElement = (Element)list.item(i);
            baseElement.getParentNode().removeChild(baseElement);
            if (!baseElement.hasAttribute("href") || !logger.isLoggable(Level.FINE)) continue;
            logger.fine("Removing base tag pointing to: " + baseElement.getAttribute("href") + " for gadget: " + gadget.getContext().getUrl().toString());
        }
        mc.documentChanged();
    }

    public void rewrite(HttpRequest request, HttpResponseBuilder response) {
        if (RewriterUtils.isHtml(request, response)) {
            Gadget context = DomWalker.makeGadget(request);
            this.rewrite(context, (MutableContent)response);
        }
    }
}

