/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.OAuthService;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthSpec {
    private final Map<String, OAuthService> serviceMap = Maps.newHashMap();

    public OAuthSpec(Element element, Uri base) throws SpecParserException {
        NodeList services = element.getElementsByTagName("Service");
        for (int i = 0; i < services.getLength(); ++i) {
            Node node = services.item(i);
            if (node.getNodeType() != 1) continue;
            this.parseService((Element)node, base);
        }
    }

    private void parseService(Element serviceElement, Uri base) throws SpecParserException {
        OAuthService service = new OAuthService(serviceElement, base);
        this.serviceMap.put(service.getName(), service);
    }

    public Map<String, OAuthService> getServices() {
        return Collections.unmodifiableMap(this.serviceMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<OAuth>");
        for (Map.Entry<String, OAuthService> entry : this.serviceMap.entrySet()) {
            sb.append("<Service name='");
            sb.append(entry.getKey());
            sb.append("'>");
            OAuthService service = entry.getValue();
            sb.append(service.getRequestUrl().toString("Request"));
            sb.append(service.getAccessUrl().toString("Access"));
            sb.append("<Authorization url='").append(service.getAuthorizationUrl().toString()).append("'/>");
            sb.append("</Service>");
        }
        sb.append("</OAuth>");
        return sb.toString();
    }
}

