/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.quasiliteral.AlphaRenaming;
import com.google.caja.parser.quasiliteral.NameContext;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.SafeIdentifierMaker;
import com.google.caja.util.Sets;
import java.util.Arrays;
import java.util.Set;

public class AlphaRenamingTest
extends CajaTestCase {
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testLiteral() throws Exception {
        this.assertRenamed("1", "1", new String[0]);
        this.assertRenamed("1", "1", "foo", "bar");
        this.assertRenamed("'foo'", "'foo'", "foo", "bar");
        this.assertRenamed("null", "null", "foo", "bar");
        this.assertNoErrors();
    }

    public final void testGlobals() throws Exception {
        this.assertRenamed("c - a * b", "foo - bar * baz", "bar", "baz", "foo");
        this.assertRenamed("c - a * b", "c - a * b", "a", "b", "c");
        this.assertNoErrors();
    }

    public final void testFreeGlobals() throws Exception {
        this.assertRenamed("null", "z", "a", "b", "c");
        this.assertMessage(true, RewriterMessageType.FREE_VARIABLE, MessageLevel.ERROR, MessagePart.Factory.valueOf("z"));
        this.assertNoErrors();
    }

    public final void testPropertyNames() throws Exception {
        this.assertRenamed("null.bar", "foo.bar", new String[0]);
        this.assertMessage(true, RewriterMessageType.FREE_VARIABLE, MessageLevel.ERROR, MessagePart.Factory.valueOf("foo"));
        this.assertRenamed("a.bar", "foo.bar", "foo", "bar");
        this.assertRenamed("b.foo", "bar.foo", "foo", "bar");
        this.assertRenamed("b[a]", "bar[foo]", "foo", "bar");
        this.assertNoErrors();
    }

    public final void testObjects1() throws Exception {
        this.assertRenamed("({ x: a })", "({ x: foo })", "foo");
        this.assertNoErrors();
        this.assertRenamed("({ x: null })", "({ x: foo })", new String[0]);
        this.assertMessage(true, RewriterMessageType.FREE_VARIABLE, MessageLevel.ERROR, MessagePart.Factory.valueOf("foo"));
        this.assertNoErrors();
    }

    public final void testGlobalThis() throws Exception {
        this.assertRenamed("null.foo()", "this.foo()", new String[0]);
        this.assertMessage(true, RewriterMessageType.THIS_IN_GLOBAL_CONTEXT, MessageLevel.FATAL_ERROR, new MessagePart[0]);
        this.assertNoErrors();
    }

    public final void testGlobalArguments() throws Exception {
        this.assertRenamed("null.length", "arguments.length", new String[0]);
        this.assertMessage(true, RewriterMessageType.ARGUMENTS_IN_GLOBAL_CONTEXT, MessageLevel.ERROR, new MessagePart[0]);
        this.assertNoErrors();
    }

    public final void testFunctionConstructor() throws Exception {
        this.assertRenamed("(function c(d, e) {  var f = d + e;  return f > 0 ? c(d - 1, e - 1) : a * f;})", "(function fn(x, y) {  var sum = x + y;  return sum > 0 ? fn(x - 1, y - 1) : factor * sum;})", "factor", "unused");
        this.assertNoErrors();
    }

    public final void testFunctionDeclaration() throws Exception {
        this.assertRenamed("(function () {  function b(d, e) {    var c = b;    return d * e - a;  }  return b;})()", "(function () {  function foo(bar, baz) {    return bar * baz - global;  }  return foo;})()", "global");
        this.assertNoErrors();
    }

    public final void testRecursiveFunctionDeclaration() throws Exception {
        this.assertRenamed("(function () {  function a(c) {    var b = a;    return c < 2 ? c : b(c - 2) + b(c - 1);  }})()", "(function () {  function fib(n) {    return n < 2 ? n : fib(n - 2) + fib(n - 1);  }})()", new String[0]);
        this.assertNoErrors();
    }

    public final void testLocalThis() throws Exception {
        this.assertRenamed("(function () { var a = this; return a; })", "(function () { return this; })", new String[0]);
        this.assertNoErrors();
    }

    public final void testLocalArguments() throws Exception {
        this.assertRenamed("(function () { var a = arguments; return a; })", "(function () { return arguments; })", new String[0]);
        this.assertNoErrors();
    }

    public final void testCatch() throws Exception {
        this.assertRenamed("(function (a) { try {} catch (b) { throw b; } return a; })", "(function (e) { try {} catch (e) { throw e; } return e; })", new String[0]);
        this.assertMessage(true, MessageType.MASKING_SYMBOL, MessageLevel.ERROR, MessagePart.Factory.valueOf("e"));
        this.assertNoErrors();
    }

    public final void testMaskingFunctionDeclarations() throws Exception {
        this.assertRenamed("(function () {  function b() {    function c() {      var d = c;      return d, a;    }    return c;  }  return b;})", "(function () {  function f() {    function f() {      return f, global;    }    return f;  }  return f;})", "global");
        this.assertMessage(true, MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR, FilePosition.instance(this.is, 1, 44, 44, 1), FilePosition.instance(this.is, 1, 26, 26, 1), MessagePart.Factory.valueOf("f"));
        this.assertNoErrors();
    }

    public final void testMaskingFunctionConstructors() throws Exception {
        this.assertRenamed("(function b() { return b, function c() { return c, a; }; })", "(function f() { return f, function f() { return f, global; }; })", "global");
        this.assertNoErrors();
    }

    public final void testMaskingGlobals() throws Exception {
        this.assertRenamed("(function(){var b=(function(){var c=2;return c;})();return b;})()", "(function(){var x=(function(){var x=2;return x;})();return x;})()", "x");
        this.assertNoErrors();
    }

    public final void testMaskingLocals() throws Exception {
        this.assertRenamed("a + (function () { var b = 2; return b; })()", "x + (function () { var x = 2; return x; })()", "x");
        this.assertNoErrors();
    }

    public final void testMaskingFormals() throws Exception {
        this.assertRenamed("a + (function (b) {       function c(e) { var d = c; return e * e; }       return c(b);     })()", "x + (function (x) { function f(x) { return x * x; } return f(x); })()", "x");
        this.assertNoErrors();
    }

    public final void testVarArguments() throws Exception {
        this.assertRenamed("(function () {  var a = arguments;  var a = a;  return a;})", "(function () {  var arguments = arguments;  return arguments;})", new String[0]);
        this.assertMessage(true, RewriterMessageType.CANNOT_MASK_IDENTIFIER, MessageLevel.FATAL_ERROR, MessagePart.Factory.valueOf("arguments"));
        this.assertNoErrors();
    }

    public final void testVarMaskingFunctionSelfName() throws Exception {
        this.assertRenamed("(function b() { var b = b; return b; })", "(function f() { var f = f; return f; })", "f");
        this.assertMessage(true, MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR, MessagePart.Factory.valueOf("f"));
        this.assertNoErrors();
    }

    public final void testMultiDeclaration() throws Exception {
        this.assertRenamed("(function (a, b, c) { var c, d, e, d; return a + b + c + d + e; })", "(function (m, n, o) { var o, p, q, p; return m + n + o + p + q; })", new String[0]);
        this.assertNoErrors();
    }

    public final void testSynthetics() throws Exception {
        this.assertRenamed("(function foo___(b, y___, d) {  var w___ = d * d;  function inner___() {}  return b + y___ * w___;})", "(function foo___(x, y___, z) {  var w___ = z * z;  function inner___() {}  return x + y___ * w___;})", new String[0]);
    }

    public final void testSanityChecks() throws Exception {
        this.assertRenamed("null", "___.foo()", new String[0]);
        this.assertMessage(true, RewriterMessageType.ALPHA_RENAMING_FAILURE, MessageLevel.ERROR, MessagePart.Factory.valueOf(Arrays.asList(MessagePart.Factory.valueOf("___"))));
        this.assertRenamed("___.foo()", "___.foo()", "___");
        this.assertNoErrors();
    }

    public final void testRenamingOfPseudoKeywords() throws Exception {
        this.assertRenamed("[function (a) { var a = arguments; return a; }, function () { var b = arguments; return b; }]", "[function (arguments) { return arguments; }, function () { return arguments; }]", new String[0]);
        this.assertRenamed("[function (b) { return b; }, function () { return a; }]", "[function (undefined) { return undefined; }, function () { return undefined; }]", "undefined");
        this.assertMessage(true, MessageType.DUPLICATE_FORMAL_PARAM, MessageLevel.ERROR, MessagePart.Factory.valueOf("arguments"));
        this.assertMessage(true, RewriterMessageType.CANNOT_MASK_IDENTIFIER, MessageLevel.FATAL_ERROR, MessagePart.Factory.valueOf("arguments"));
        this.assertNoErrors();
    }

    public final void testDuplicateFormals() throws Exception {
        this.assertRenamed("function (a, b, a) { return a - b; }", "function (x, y, x) { return x - y; }", new String[0]);
        this.assertMessage(true, MessageType.DUPLICATE_FORMAL_PARAM, MessageLevel.ERROR, MessagePart.Factory.valueOf("x"));
        this.assertMessage(true, MessageType.DUPLICATE_FORMAL_PARAM, MessageLevel.ERROR, MessagePart.Factory.valueOf("a"));
        this.assertNoErrors();
    }

    private void assertRenamed(String golden, String input, String ... globals) throws Exception {
        NameContext nc = new NameContext(new SafeIdentifierMaker());
        Set<String> freeSynthetics = Sets.newLinkedHashSet();
        for (String global : globals) {
            if (global.endsWith("__")) {
                freeSynthetics.add(global);
                continue;
            }
            nc.declare(global, FilePosition.startOfFile(this.is));
        }
        Expression renamed = AlphaRenaming.rename(AlphaRenamingTest.synth(this.jsExpr(this.fromString(input))), nc, freeSynthetics, this.mq);
        AlphaRenamingTest.assertEquals((String)AlphaRenamingTest.render(this.jsExpr(this.fromString(golden))), (String)AlphaRenamingTest.render(renamed));
    }

    private static Expression synth(Expression e) {
        e.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> chain) {
                FunctionConstructor fc;
                Object n = chain.node;
                if (n instanceof Identifier) {
                    Identifier id = (Identifier)n;
                    if (id.getName() != null && id.getName().endsWith("___")) {
                        SyntheticNodes.s(id);
                    }
                } else if (n instanceof FunctionConstructor && (fc = (FunctionConstructor)n).getIdentifierName() != null && fc.getIdentifierName().endsWith("___")) {
                    SyntheticNodes.s(fc);
                }
                return true;
            }
        }, null);
        return e;
    }
}

