/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.lang.reflect.Method;
import java.util.List;
import org.exoplatform.services.database.DAO;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.ReflectionUtil;
import org.exoplatform.services.database.annotation.Query;
import org.exoplatform.services.database.annotation.Table;
import org.exoplatform.services.database.annotation.TableField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilder {
    private int databaseType = 0;

    public QueryBuilder() {
    }

    public QueryBuilder(int dbType) {
        this.databaseType = dbType;
    }

    public <T extends DBObject> String createSelectQuery(Class<T> type, long id) throws Exception {
        Table table = type.getAnnotation(Table.class);
        TableField[] fields = table.field();
        StringBuilder query = new StringBuilder("SELECT ");
        for (int i = 0; i < fields.length; ++i) {
            TableField field = fields[i];
            query.append(field.name());
            if (i == fields.length - 1) continue;
            query.append(", ");
        }
        query.append(" FROM ").append(table.name());
        if (id > -1L) {
            query.append(" WHERE ID = ").append(id);
        }
        return query.toString();
    }

    public <T extends DBObject> String createUpdateQuery(Class<T> type) throws Exception {
        Table table = type.getAnnotation(Table.class);
        TableField[] fields = table.field();
        StringBuilder query = new StringBuilder("UPDATE ").append(table.name()).append(" SET ");
        for (int i = 0; i < fields.length; ++i) {
            TableField field = fields[i];
            query.append(field.name()).append(" = '$").append(field.name()).append('\'');
            if (i != fields.length - 1) {
                query.append(", ");
                continue;
            }
            query.append(" WHERE ID = $id");
        }
        return query.toString();
    }

    public <T extends DBObject> String createInsertQuery(Class<T> type) throws Exception {
        int i;
        Table table = type.getAnnotation(Table.class);
        TableField[] fields = table.field();
        StringBuilder query = new StringBuilder("INSERT INTO ").append(table.name()).append("(ID, ");
        for (i = 0; i < fields.length; ++i) {
            TableField field = fields[i];
            query.append(field.name());
            if (i != fields.length - 1) {
                query.append(", ");
                continue;
            }
            query.append(") VALUES($id, ");
        }
        for (i = 0; i < fields.length; ++i) {
            query.append("'$").append(fields[i].name()).append('\'');
            if (i != fields.length - 1) {
                query.append(", ");
                continue;
            }
            query.append(")");
        }
        return query.toString();
    }

    public <T extends DBObject> String createUpdateQuery(Class<T> type, long id) throws Exception {
        Table table = type.getAnnotation(Table.class);
        TableField[] fields = table.field();
        StringBuilder query = new StringBuilder("UPDATE ").append(table.name()).append(" SET ");
        for (int i = 0; i < fields.length; ++i) {
            TableField field = fields[i];
            query.append(field.name()).append(" = ?");
            if (i != fields.length - 1) {
                query.append(", ");
                continue;
            }
            query.append(" WHERE ID = ").append(id);
        }
        return query.toString();
    }

    public <T extends DBObject> String createInsertQuery(Class<T> clazz, long id) throws Exception {
        int i;
        Table table = clazz.getAnnotation(Table.class);
        TableField[] fields = table.field();
        StringBuilder query = new StringBuilder("INSERT INTO ").append(table.name()).append("(ID, ");
        for (i = 0; i < fields.length; ++i) {
            TableField field = fields[i];
            query.append(field.name());
            if (i == fields.length - 1) continue;
            query.append(", ");
        }
        query.append(") VALUES(").append(id).append(", ");
        for (i = 0; i < fields.length; ++i) {
            query.append("?");
            if (i != fields.length - 1) {
                query.append(", ");
                continue;
            }
            query.append(")");
        }
        return query.toString();
    }

    public <T extends DBObject> String createRemoveQuery(Class<T> type, long id) throws Exception {
        Table table = type.getAnnotation(Table.class);
        StringBuilder builder = new StringBuilder("DELETE FROM ");
        builder.append(table.name()).append(" WHERE ID = ").append(id).toString();
        return builder.toString();
    }

    public <T extends DAO> String getQuery(Class<T> clazz, String name) throws Exception {
        Query query = clazz.getAnnotation(Query.class);
        String value = null;
        if (query != null && query.name().equals(name)) {
            value = this.getQuery(query);
        }
        if (value != null) {
            return value;
        }
        List<Method> list = ReflectionUtil.getMethod(clazz, name);
        for (Method method : list) {
            query = method.getAnnotation(Query.class);
            if (query != null && query.name().equals(name)) {
                value = this.getQuery(query);
            }
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String getQuery(Query query) {
        switch (this.databaseType) {
            case 0: {
                return query.standardSQL();
            }
            case 1: {
                if (query.hsqlSQL().length() > 0) {
                    return query.hsqlSQL();
                }
            }
            case 2: {
                if (query.mysqlSQL().length() > 0) {
                    return query.mysqlSQL();
                }
            }
            case 6: {
                if (query.mssqlSQL().length() > 0) {
                    return query.mssqlSQL();
                }
            }
            case 5: {
                if (query.oracleSQL().length() > 0) {
                    return query.oracleSQL();
                }
            }
            case 3: {
                if (query.db2SQL().length() > 0) {
                    return query.db2SQL();
                }
            }
            case 4: {
                if (query.derbySQL().length() > 0) {
                    return query.derbySQL();
                }
            }
            case 8: {
                if (query.postgresSQL().length() > 0) {
                    return query.postgresSQL();
                }
            }
            case 7: {
                if (query.sysbaseSQL().length() <= 0) break;
                return query.sysbaseSQL();
            }
        }
        return query.standardSQL();
    }

    public String mapDataToSql(String template, String[][] parameters) throws Exception {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int start = 0;
        while (i < template.length()) {
            int j;
            if (template.charAt(i) != '$') {
                ++i;
                continue;
            }
            if (i > 0 && template.charAt(i - 1) == '\\') {
                builder.append(template.subSequence(start, i - 1));
                start = i++;
                continue;
            }
            if (i == template.length() - 1) break;
            for (j = i + 1; !(j >= template.length() || Character.isWhitespace(template.charAt(j)) || template.charAt(j) == '\'' && template.charAt(j - 1) != '\\' || template.charAt(j) == ',' && template.charAt(j - 1) != '\\'); ++j) {
            }
            String name = template.substring(i + 1, j);
            start = this.replace(template, builder, parameters, name, start, i);
            ++i;
        }
        if (start > 0 && start < template.length()) {
            builder.append(template.subSequence(start, template.length()));
        }
        if (builder.length() < 1) {
            return template.toString();
        }
        return builder.toString();
    }

    private int replace(String template, StringBuilder builder, String[][] parameters, String name, int start, int current) throws Exception {
        for (int k = 0; k < parameters.length; ++k) {
            if (!parameters[k][0].equals(name)) continue;
            builder.append(template.subSequence(start, current)).append(parameters[k][1]);
            return current + 1 + name.length();
        }
        return start;
    }

    public String encode(CharSequence seq) {
        if (seq.length() < 1) {
            return ((Object)seq).toString();
        }
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) != '\'') continue;
            builder.append(seq.subSequence(start, i)).append("''");
            start = i + 1;
        }
        if (start > 0 && start < seq.length()) {
            builder.append(seq.subSequence(start, seq.length()));
        }
        if (builder.length() < 1) {
            return ((Object)seq).toString();
        }
        return builder.toString();
    }
}

