/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.JCRItemExistsException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRRestore {
    private final DataManager dataManager;
    private final FileCleaner fileCleaner;
    private final File tempDir = new File(PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir"));

    public JCRRestore(DataManager dataManager, FileCleaner fileCleaner) {
        this.dataManager = dataManager;
        this.fileCleaner = fileCleaner;
    }

    public static File getFullBackupFile(File restoreDir) {
        Pattern p = Pattern.compile(".+\\.0");
        for (File f : PrivilegedFileHelper.listFiles((File)restoreDir, (FileFilter)new FileFilter(){

            public boolean accept(File pathname) {
                Pattern p = Pattern.compile(".+\\.[0-9]+");
                Matcher m = p.matcher(pathname.getName());
                return m.matches();
            }
        })) {
            Matcher m = p.matcher(f.getName());
            if (!m.matches()) continue;
            return f;
        }
        return null;
    }

    public static List<File> getIncrementalFiles(File restoreDir) {
        ArrayList<File> list = new ArrayList<File>();
        Pattern fullBackupPattern = Pattern.compile(".+\\.0");
        for (File f : PrivilegedFileHelper.listFiles((File)restoreDir, (FileFilter)new FileFilter(){

            public boolean accept(File pathname) {
                Pattern p = Pattern.compile(".+\\.[0-9]+");
                Matcher m = p.matcher(pathname.getName());
                return m.matches();
            }
        })) {
            if (fullBackupPattern.matcher(f.getName()).matches()) continue;
            list.add(f);
        }
        return list;
    }

    public void incrementalRestore(File incrementalBackupFile) throws FileNotFoundException, IOException, ClassNotFoundException, RepositoryException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(PrivilegedFileHelper.fileInputStream((File)incrementalBackupFile));
            while (true) {
                TransactionChangesLog changesLog = this.readExternal(ois);
                changesLog.setSystemId("JCR_CORE_RESOTRE_WORKSPACE_INITIALIZER_SYSTEM_ID");
                ChangesLogIterator cli = changesLog.getLogIterator();
                while (cli.hasNextLog()) {
                    if (cli.nextLog().getEventType() != 0x400000) continue;
                    cli.removeLog();
                }
                this.saveChangesLog(changesLog);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void saveChangesLog(TransactionChangesLog changesLog) throws RepositoryException {
        try {
            this.dataManager.save(changesLog);
        }
        catch (JCRInvalidItemStateException e) {
            TransactionChangesLog normalizeChangesLog = this.getNormalizedChangesLog(e.getIdentifier(), e.getState(), changesLog);
            if (normalizeChangesLog != null) {
                this.saveChangesLog(normalizeChangesLog);
            }
            throw new RepositoryException("Collisions found during save of restore changes log, but caused item is not found by ID " + e.getIdentifier() + ". " + (Object)((Object)e), (Throwable)((Object)e));
        }
        catch (JCRItemExistsException e) {
            TransactionChangesLog normalizeChangesLog = this.getNormalizedChangesLog(e.getIdentifier(), e.getState(), changesLog);
            if (normalizeChangesLog != null) {
                this.saveChangesLog(normalizeChangesLog);
            }
            throw new RepositoryException("Collisions found during save of restore changes log, but caused item is not found by ID " + e.getIdentifier() + ". " + (Object)((Object)e), (Throwable)((Object)e));
        }
    }

    private TransactionChangesLog getNormalizedChangesLog(String collisionID, int state, TransactionChangesLog changesLog) {
        ItemState citem = changesLog.getItemState(collisionID);
        if (citem != null) {
            TransactionChangesLog result = new TransactionChangesLog();
            result.setSystemId(changesLog.getSystemId());
            ChangesLogIterator cli = changesLog.getLogIterator();
            while (cli.hasNextLog()) {
                ArrayList<ItemState> normalized = new ArrayList<ItemState>();
                PlainChangesLog next = cli.nextLog();
                for (ItemState change : next.getAllStates()) {
                    if (state == change.getState()) {
                        ItemData item = change.getData();
                        if (citem.isNode()) {
                            if (item.getIdentifier().equals(collisionID) || item.getQPath().isDescendantOf(citem.getData().getQPath())) continue;
                            normalized.add(change);
                            continue;
                        }
                        if (item.getIdentifier().equals(collisionID)) continue;
                        normalized.add(change);
                        continue;
                    }
                    normalized.add(change);
                }
                PlainChangesLogImpl plog = new PlainChangesLogImpl(normalized, next.getSessionId(), next.getEventType());
                result.addLog(plog);
            }
            return result;
        }
        return null;
    }

    private TransactionChangesLog readExternal(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int changesLogType = in.readInt();
        TransactionChangesLog transactionChangesLog = null;
        if (changesLogType == 2) {
            transactionChangesLog = (TransactionChangesLog)in.readObject();
            int iFixupStream = in.readInt();
            ArrayList<FixupStream> listFixupStreams = new ArrayList<FixupStream>();
            for (int i = 0; i < iFixupStream; ++i) {
                FixupStream fs = new FixupStream();
                fs.readExternal(in);
                listFixupStreams.add(fs);
            }
            int iStreamCount = in.readInt();
            ArrayList<SpoolFile> listFiles = new ArrayList<SpoolFile>();
            for (int i = 0; i < iStreamCount; ++i) {
                long fileSize = in.readLong();
                listFiles.add(this.getAsFile(in, fileSize));
            }
            RestoreChangesLog restoreChangesLog = new RestoreChangesLog(transactionChangesLog, listFixupStreams, listFiles, this.fileCleaner);
            restoreChangesLog.restore();
        } else if (changesLogType == 1) {
            transactionChangesLog = (TransactionChangesLog)in.readObject();
        }
        return transactionChangesLog;
    }

    private SpoolFile getAsFile(ObjectInputStream ois, long fileSize) throws IOException {
        int bufferSize = 8192;
        byte[] buf = new byte[bufferSize];
        SpoolFile tempFile = SpoolFile.createTempFile("vdincb" + System.currentTimeMillis(), ".stmp", this.tempDir);
        FileOutputStream fos = PrivilegedFileHelper.fileOutputStream((File)tempFile);
        for (long readBytes = fileSize; readBytes > 0L; readBytes -= (long)bufferSize) {
            if (readBytes >= (long)bufferSize) {
                ois.readFully(buf);
                fos.write(buf);
                continue;
            }
            if (readBytes >= (long)bufferSize) continue;
            ois.readFully(buf, 0, (int)readBytes);
            fos.write(buf, 0, (int)readBytes);
        }
        fos.flush();
        fos.close();
        return tempFile;
    }

    class FixupStream
    implements Externalizable {
        int iItemStateId = -1;
        int iValueDataId = -1;

        public FixupStream() {
        }

        public FixupStream(int itemState_, int valueData_) {
            this.iItemStateId = itemState_;
            this.iValueDataId = valueData_;
        }

        public int getItemSateId() {
            return this.iItemStateId;
        }

        public int getValueDataId() {
            return this.iValueDataId;
        }

        public boolean compare(FixupStream fs) {
            boolean b = true;
            if (fs.getItemSateId() != this.getItemSateId()) {
                b = false;
            }
            if (fs.getValueDataId() != this.getValueDataId()) {
                b = false;
            }
            return b;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.iItemStateId = in.readInt();
            this.iValueDataId = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.iItemStateId);
            out.writeInt(this.iValueDataId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RestoreChangesLog {
        private TransactionChangesLog itemDataChangesLog;
        private List<FixupStream> listFixupStream;
        private List<SpoolFile> listFile;
        private FileCleaner fileCleaner;

        public RestoreChangesLog(TransactionChangesLog transactionChangesLog, List<FixupStream> listFixupStreams, List<SpoolFile> listFiles, FileCleaner fileCleaner) {
            this.itemDataChangesLog = transactionChangesLog;
            this.listFixupStream = listFixupStreams;
            this.listFile = listFiles;
            this.fileCleaner = fileCleaner;
        }

        public TransactionChangesLog getItemDataChangesLog() {
            return this.itemDataChangesLog;
        }

        public void restore() throws IOException {
            int i;
            List<ItemState> listItemState = this.itemDataChangesLog.getAllStates();
            for (i = 0; i < this.listFixupStream.size(); ++i) {
                ItemState itemState = listItemState.get(this.listFixupStream.get(i).getItemSateId());
                ItemData itemData = itemState.getData();
                PersistedPropertyData propertyData = (PersistedPropertyData)itemData;
                ValueData vd = propertyData.getValues().get(this.listFixupStream.get(i).getValueDataId());
                propertyData.getValues().set(this.listFixupStream.get(i).getValueDataId(), new StreamPersistedValueData(vd.getOrderNumber(), this.listFile.get(i)));
            }
            for (i = 0; i < this.listFile.size(); ++i) {
                this.fileCleaner.addFile(this.listFile.get(i));
            }
        }

        public class Type {
            public static final int ItemDataChangesLog_without_Streams = 1;
            public static final int ItemDataChangesLog_with_Streams = 2;
        }
    }
}

