/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.inject.ImplementedBy;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.opensocial.model.Album;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ImplementedBy(value=NotImplementedAlbumService.class)
public interface AlbumService {
    public Future<Album> getAlbum(UserId var1, String var2, Set<String> var3, String var4, SecurityToken var5) throws ProtocolException;

    public Future<RestfulCollection<Album>> getAlbums(UserId var1, String var2, Set<String> var3, CollectionOptions var4, Set<String> var5, SecurityToken var6) throws ProtocolException;

    public Future<RestfulCollection<Album>> getAlbums(Set<UserId> var1, GroupId var2, String var3, Set<String> var4, CollectionOptions var5, SecurityToken var6) throws ProtocolException;

    public Future<Void> deleteAlbum(UserId var1, String var2, String var3, SecurityToken var4) throws ProtocolException;

    public Future<Void> createAlbum(UserId var1, String var2, Album var3, SecurityToken var4) throws ProtocolException;

    public Future<Void> updateAlbum(UserId var1, String var2, Album var3, String var4, SecurityToken var5) throws ProtocolException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotImplementedAlbumService
    implements AlbumService {
        @Override
        public Future<Album> getAlbum(UserId userId, String appId, Set<String> fields, String albumId, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(400, "Not Implemented");
        }

        @Override
        public Future<RestfulCollection<Album>> getAlbums(UserId userId, String appId, Set<String> fields, CollectionOptions options, Set<String> albumIds, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(400, "Not Implemented");
        }

        @Override
        public Future<RestfulCollection<Album>> getAlbums(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(400, "Not Implemented");
        }

        @Override
        public Future<Void> deleteAlbum(UserId userId, String appId, String albumId, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(400, "Not Implemented");
        }

        @Override
        public Future<Void> createAlbum(UserId userId, String appId, Album album, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(400, "Not Implemented");
        }

        @Override
        public Future<Void> updateAlbum(UserId userId, String appId, Album album, String albumId, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(400, "Not Implemented");
        }
    }
}

