/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityHelper {
    public static <E> E doPrivilegedIOExceptionAction(PrivilegedExceptionAction<E> action) throws IOException {
        try {
            return SecurityHelper.doPrivilegedExceptionAction(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <E> E doPrivilegedNamingExceptionAction(PrivilegedExceptionAction<E> action) throws NamingException {
        try {
            return SecurityHelper.doPrivilegedExceptionAction(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <E> E doPrivilegedSQLExceptionAction(PrivilegedExceptionAction<E> action) throws SQLException {
        try {
            return SecurityHelper.doPrivilegedExceptionAction(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <E> E doPrivilegedParserConfigurationOrSAXExceptionAction(PrivilegedExceptionAction<E> action) throws ParserConfigurationException, SAXException {
        try {
            return SecurityHelper.doPrivilegedExceptionAction(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof ParserConfigurationException) {
                throw (ParserConfigurationException)cause;
            }
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <E> E doPrivilegedParserConfigurationAction(PrivilegedExceptionAction<E> action) throws ParserConfigurationException {
        try {
            return SecurityHelper.doPrivilegedExceptionAction(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof ParserConfigurationException) {
                throw (ParserConfigurationException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <E> E doPrivilegedSAXExceptionAction(PrivilegedExceptionAction<E> action) throws SAXException {
        try {
            return SecurityHelper.doPrivilegedExceptionAction(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <E> E doPrivilegedMalformedURLExceptionAction(PrivilegedExceptionAction<E> action) throws MalformedURLException {
        try {
            return SecurityHelper.doPrivilegedExceptionAction(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof MalformedURLException) {
                throw (MalformedURLException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <E> E doPrivilegedAction(PrivilegedAction<E> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    public static <E> E doPrivilegedExceptionAction(PrivilegedExceptionAction<E> action) throws PrivilegedActionException {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        try {
            return action.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }
}

