/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.impl.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.organization.BaseOrganizationService;
import org.exoplatform.services.organization.ExtendedUserHandler;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.exoplatform.services.organization.impl.mock.LazyListImpl;
import org.exoplatform.services.security.PasswordEncrypter;

public class DummyOrganizationService
extends BaseOrganizationService {
    public static final String GROUPNAME_PLATFORM = "platform";
    public static final String GROUPID_PLATFORM = "/platform";
    public static final String GROUPNAME_USERS = "users";
    public static final String GROUPID_USERS = "/platform/users";
    public static final String GROUPNAME_ADMINISTRATORS = "administrators";
    public static final String GROUPID_ADMINISTRATORS = "/platform/administrators";

    public DummyOrganizationService() {
        this.userDAO_ = new UserHandlerImpl();
        this.groupDAO_ = new GroupHandlerImpl();
        this.membershipDAO_ = new MembershipHandlerImpl();
        this.userProfileDAO_ = new DummyUserProfileHandler();
    }

    public class DummyUserProfileHandler
    implements UserProfileHandler {
        public void addUserProfileEventListener(UserProfileEventListener listener) {
        }

        public void removeUserProfileEventListener(UserProfileEventListener listener) {
        }

        public UserProfile createUserProfileInstance() {
            return new UserProfileImpl();
        }

        public UserProfile createUserProfileInstance(String userName) {
            return new UserProfileImpl(userName);
        }

        public UserProfile findUserProfileByName(String userName) throws Exception {
            return this.createUserProfileInstance(userName);
        }

        public Collection findUserProfiles() throws Exception {
            return new ArrayList();
        }

        public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
            return new UserProfileImpl();
        }

        public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        }
    }

    public static class DummyGroup
    implements Group {
        private String id;
        private String parentId;
        private String name;
        private String label;
        private String desc;

        public DummyGroup(String parentId, String id, String name) {
            this.name = name;
            this.id = id;
            this.parentId = parentId;
            this.desc = "group " + id;
            this.label = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
            this.desc = "group " + id;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public String getGroupName() {
            return this.name;
        }

        public void setGroupName(String name) {
            this.name = name;
            this.label = name;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String s) {
            this.label = s;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String s) {
            this.desc = s;
        }

        public String toString() {
            return "Group[" + this.id + "|" + this.name + "]";
        }
    }

    public static class GroupHandlerImpl
    implements GroupHandler {
        public Group createGroupInstance() {
            return null;
        }

        public void createGroup(Group group, boolean broadcast) throws Exception {
        }

        public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        }

        public void saveGroup(Group group, boolean broadcast) throws Exception {
        }

        public Group removeGroup(Group group, boolean broadcast) throws Exception {
            return null;
        }

        public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
            return null;
        }

        public Group findGroupById(String groupId) throws Exception {
            if (groupId.equals(DummyOrganizationService.GROUPID_ADMINISTRATORS)) {
                return new DummyGroup(DummyOrganizationService.GROUPID_PLATFORM, DummyOrganizationService.GROUPID_ADMINISTRATORS, DummyOrganizationService.GROUPNAME_ADMINISTRATORS);
            }
            if (groupId.equals(DummyOrganizationService.GROUPID_USERS)) {
                return new DummyGroup(DummyOrganizationService.GROUPID_PLATFORM, DummyOrganizationService.GROUPID_USERS, DummyOrganizationService.GROUPNAME_USERS);
            }
            return new DummyGroup("", "/" + groupId, groupId);
        }

        public Collection findGroups(Group parent) throws Exception {
            if (parent.getId().equals(DummyOrganizationService.GROUPID_PLATFORM)) {
                ArrayList<DummyGroup> groups = new ArrayList<DummyGroup>();
                groups.add(new DummyGroup(DummyOrganizationService.GROUPID_PLATFORM, DummyOrganizationService.GROUPID_USERS, DummyOrganizationService.GROUPNAME_USERS));
                groups.add(new DummyGroup(DummyOrganizationService.GROUPID_PLATFORM, DummyOrganizationService.GROUPID_ADMINISTRATORS, DummyOrganizationService.GROUPNAME_ADMINISTRATORS));
                return groups;
            }
            return null;
        }

        public void addGroupEventListener(GroupEventListener listener) {
        }

        public void removeGroupEventListener(GroupEventListener listener) {
        }

        public Collection getAllGroups() {
            ArrayList<DummyGroup> groups = new ArrayList<DummyGroup>();
            groups.add(new DummyGroup("", DummyOrganizationService.GROUPID_PLATFORM, DummyOrganizationService.GROUPNAME_PLATFORM));
            groups.add(new DummyGroup(DummyOrganizationService.GROUPID_PLATFORM, DummyOrganizationService.GROUPID_USERS, DummyOrganizationService.GROUPNAME_USERS));
            groups.add(new DummyGroup(DummyOrganizationService.GROUPID_PLATFORM, DummyOrganizationService.GROUPID_ADMINISTRATORS, DummyOrganizationService.GROUPNAME_ADMINISTRATORS));
            return groups;
        }

        public Collection findGroupsOfUser(String user) throws Exception {
            ArrayList<DummyGroup> groups = new ArrayList<DummyGroup>(1);
            if (user.startsWith("exo") || user.equals("demo") || user.equals("mary") || user.equals("marry") || user.equals("james")) {
                groups.add(new DummyGroup(DummyOrganizationService.GROUPID_PLATFORM, DummyOrganizationService.GROUPID_USERS, DummyOrganizationService.GROUPNAME_USERS));
            } else if (user.equals("root") || user.equals("john") || user.equals("admin")) {
                groups.add(new DummyGroup(DummyOrganizationService.GROUPID_PLATFORM, DummyOrganizationService.GROUPID_ADMINISTRATORS, DummyOrganizationService.GROUPNAME_ADMINISTRATORS));
            }
            return groups;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserHandlerImpl
    implements UserHandler,
    ExtendedUserHandler {
        private static final int DEFAULT_LIST_SIZE = 6;
        private LazyListImpl users = new LazyListImpl();

        public UserHandlerImpl() {
            UserImpl usr = new UserImpl("exo");
            usr.setPassword("exo");
            this.users.add(usr);
            usr = new UserImpl("admin");
            usr.setPassword("admin");
            this.users.add(usr);
            usr = new UserImpl("weblogic");
            usr.setPassword("11111111");
            this.users.add(usr);
            usr = new UserImpl("__anonim");
            this.users.add(usr);
            usr = new UserImpl("root");
            usr.setPassword("exo");
            this.users.add(usr);
            usr = new UserImpl("john");
            usr.setPassword("exo");
            this.users.add(usr);
            usr = new UserImpl("james");
            usr.setPassword("exo");
            this.users.add(usr);
            usr = new UserImpl("mary");
            usr.setPassword("exo");
            this.users.add(usr);
            usr = new UserImpl("marry");
            usr.setPassword("exo");
            this.users.add(usr);
            usr = new UserImpl("demo");
            usr.setPassword("exo");
            this.users.add(usr);
        }

        @Override
        public User createUserInstance() {
            UserImpl usr = new UserImpl();
            this.users.add(usr);
            return usr;
        }

        @Override
        public User createUserInstance(String username) {
            UserImpl usr = new UserImpl(username);
            this.users.add(usr);
            return usr;
        }

        @Override
        public void createUser(User user, boolean broadcast) throws Exception {
        }

        @Override
        public void saveUser(User user, boolean broadcast) throws Exception {
        }

        @Override
        public User removeUser(String userName, boolean broadcast) throws Exception {
            return null;
        }

        @Override
        public User findUserByName(String userName) throws Exception {
            for (User usr : this.users) {
                if (!usr.getUserName().equals(userName)) continue;
                usr.setFirstName("_" + userName);
                usr.setEmail(userName + "@mail.com");
                return usr;
            }
            return null;
        }

        @Override
        public PageList<User> findUsersByGroup(String groupId) throws Exception {
            return new LazyPageList(this.findUsersByGroupId(groupId), 10);
        }

        @Override
        public PageList<User> findUsers(Query query) throws Exception {
            return new LazyPageList((ListAccess)this.users, 10);
        }

        @Override
        public ListAccess<User> findUsersByQuery(Query query) throws Exception {
            return this.users;
        }

        @Override
        public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
            LazyListImpl users = new LazyListImpl();
            if (groupId.equals(DummyOrganizationService.GROUPID_USERS)) {
                users.add(new UserImpl("exo"));
                users.add(new UserImpl("marry"));
                users.add(new UserImpl("mary"));
                users.add(new UserImpl("james"));
                users.add(new UserImpl("demo"));
            }
            if (groupId.equals(DummyOrganizationService.GROUPID_ADMINISTRATORS)) {
                users.add(new UserImpl("root"));
                users.add(new UserImpl("john"));
                users.add(new UserImpl("admin"));
            }
            return users;
        }

        @Override
        public ListAccess<User> findAllUsers() throws Exception {
            return this.users;
        }

        @Override
        public PageList<User> getUserPageList(int pageSize) throws Exception {
            return new LazyPageList((ListAccess)this.users, 10);
        }

        @Override
        public void addUserEventListener(UserEventListener listener) {
        }

        @Override
        public void removeUserEventListener(UserEventListener listener) {
        }

        @Override
        public boolean authenticate(String username, String password, PasswordEncrypter pe) throws Exception {
            Iterator it = this.users.iterator();
            User usr = null;
            User temp = null;
            while (it.hasNext()) {
                temp = (User)it.next();
                if (!temp.getUserName().equals(username)) continue;
                usr = temp;
                break;
            }
            if (usr != null) {
                String dp;
                if (usr.getUserName().equals("__anonim")) {
                    return true;
                }
                if (pe == null ? usr.getPassword().equals(password) : (dp = new String(pe.encrypt(usr.getPassword().getBytes()))).equals(password)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean authenticate(String username, String password) throws Exception {
            return this.authenticate(username, password, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MembershipHandlerImpl
    implements MembershipHandler {
        @Override
        public void addMembershipEventListener(MembershipEventListener listener) {
        }

        @Override
        public void removeMembershipEventListener(MembershipEventListener listener) {
        }

        @Override
        public void createMembership(Membership m, boolean broadcast) throws Exception {
        }

        @Override
        public Membership createMembershipInstance() {
            return null;
        }

        @Override
        public Membership findMembership(String id) throws Exception {
            return null;
        }

        @Override
        public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
            return null;
        }

        @Override
        public Collection findMembershipsByGroup(Group group) throws Exception {
            return null;
        }

        @Override
        public ListAccess<Membership> findAllMembershipsByGroup(Group group) throws Exception {
            return null;
        }

        @Override
        public Collection findMembershipsByUser(String userName) throws Exception {
            ArrayList<MembershipImpl> memberships = new ArrayList<MembershipImpl>();
            if ("root".equals(userName) || "john".equals(userName) || "admin".equals(userName)) {
                MembershipImpl admin = new MembershipImpl();
                admin.setMembershipType("*");
                admin.setUserName(userName);
                admin.setGroupId(DummyOrganizationService.GROUPID_ADMINISTRATORS);
                memberships.add(admin);
            }
            MembershipImpl membership = new MembershipImpl();
            membership.setMembershipType("*");
            membership.setUserName(userName);
            membership.setGroupId(DummyOrganizationService.GROUPID_USERS);
            memberships.add(membership);
            return memberships;
        }

        @Override
        public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
            return null;
        }

        @Override
        public void linkMembership(User user, Group group, MembershipType m, boolean broadcast) throws Exception {
        }

        @Override
        public Membership removeMembership(String id, boolean broadcast) throws Exception {
            return null;
        }

        @Override
        public Collection removeMembershipByUser(String username, boolean broadcast) throws Exception {
            return null;
        }
    }
}

