/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.css;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.css.CssTree;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.SnippetProducer;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Join;
import com.google.caja.util.Name;
import com.google.caja.util.TestUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssParserTest
extends CajaTestCase {
    public final void testBadHashValue() {
        this.throwsParseException("h1 { color: #OOOOOO}");
    }

    public final void testUnescape() {
        FilePosition pos = FilePosition.startOfFile(this.is);
        CssParserTest.assertEquals((String)"", (String)CssParser.unescape(Token.instance("", CssTokenType.IDENT, pos)));
        CssParserTest.assertEquals((String)"foo", (String)CssParser.unescape(Token.instance("foo", CssTokenType.IDENT, pos)));
        CssParserTest.assertEquals((String)"foo", (String)CssParser.unescape(Token.instance("f\\oo", CssTokenType.IDENT, pos)));
        CssParserTest.assertEquals((String)"!important", (String)CssParser.unescape(Token.instance("! important", CssTokenType.IDENT, pos)));
        CssParserTest.assertEquals((String)"!important", (String)CssParser.unescape(Token.instance("!   important", CssTokenType.IDENT, pos)));
        CssParserTest.assertEquals((String)"'foo bar'", (String)CssParser.unescape(Token.instance("'foo bar'", CssTokenType.STRING, pos)));
        CssParserTest.assertEquals((String)"'foo bar'", (String)CssParser.unescape(Token.instance("'foo\\ bar'", CssTokenType.STRING, pos)));
        CssParserTest.assertEquals((String)"'foo bar'", (String)CssParser.unescape(Token.instance("'foo\\ b\\\nar'", CssTokenType.STRING, pos)));
        CssParserTest.assertEquals((String)"'foo bar'", (String)CssParser.unescape(Token.instance("'foo\\ b\\\rar'", CssTokenType.STRING, pos)));
        CssParserTest.assertEquals((String)"'ffoo bar'", (String)CssParser.unescape(Token.instance("'\\66 foo bar'", CssTokenType.STRING, pos)));
        CssParserTest.assertEquals((String)"foo-bar", (String)CssParser.unescape(Token.instance("\\66oo-ba\\0072", CssTokenType.IDENT, pos)));
        CssParserTest.assertEquals((String)"\\66oo-bar", (String)CssParser.unescape(Token.instance("\\\\66oo-ba\\0072", CssTokenType.IDENT, pos)));
    }

    public final void testCssParser1() throws Exception {
        this.runTestCssParser("cssparserinput1.css", "cssparsergolden1.txt", false);
    }

    public final void testCssParser2() throws Exception {
        this.runTestCssParser("cssparserinput2.css", "cssparsergolden2.txt", false);
    }

    public final void testCssParser3() throws Exception {
        this.runTestCssParser("cssparserinput3.css", "cssparsergolden3.txt", false);
    }

    public final void testCssParser4() throws Exception {
        this.runTestCssParser("cssparserinput4.css", "cssparsergolden4.txt", false);
    }

    public final void testTolerantParsing() throws Exception {
        String inputFile = "cssparserinput5.css";
        InputSource inputSource = new InputSource(TestUtil.getResource(((Object)((Object)this)).getClass(), inputFile));
        this.runTestCssParser(inputFile, "cssparsergolden5.txt", true);
        CssParserTest.assertEquals((String)TestUtil.readResource(((Object)((Object)this)).getClass(), "csssnippets5.txt").trim(), (String)this.renderSnippets(Collections.singletonMap(inputSource, TestUtil.readResource(((Object)((Object)this)).getClass(), inputFile))));
    }

    public final void testFilters() throws Exception {
        this.runTestCssParser("cssparserinput-filters.css", "cssparsergolden-filters.txt", true);
        this.assertMessagesLessSevereThan(MessageLevel.WARNING);
    }

    public final void testUserAgentHacks() throws Exception {
        this.runTestCssParser("cssparserinput-uahacks.css", "cssparsergolden-uahacks.txt", true);
        this.assertMessagesLessSevereThan(MessageLevel.WARNING);
    }

    public final void testFilterFilePositions() throws Exception {
        CssTree.DeclarationGroup ss = this.cssDecls(this.fromString("filter:progid:foo.bar.baz(a=1) progid:foo.bar.baz(a=2)"));
        this.assertMessagesLessSevereThan(MessageLevel.WARNING);
        CssParserTest.assertEquals((int)1, (int)ss.children().size());
        CssTree.PropertyDeclaration d = (CssTree.PropertyDeclaration)ss.children().get(0);
        this.assertFilePosition(1, 55, d);
        CssTree.Property p = d.getProperty();
        this.assertFilePosition(1, 7, p);
        CssParserTest.assertEquals((Object)Name.css("filter"), (Object)p.getPropertyName());
        CssTree.Expr e = d.getExpr();
        this.assertFilePosition(8, 55, e);
        CssParserTest.assertEquals((int)2, (int)e.getNTerms());
        CssTree.Term t0 = e.getNthTerm(0);
        this.assertFilePosition(8, 31, t0);
        CssTree.ProgId progId0 = (CssTree.ProgId)t0.getExprAtom();
        this.assertFilePosition(8, 31, progId0);
        CssParserTest.assertEquals((Object)Name.css("foo.bar.baz"), (Object)progId0.getName());
        CssParserTest.assertEquals((int)1, (int)progId0.children().size());
        CssTree.ProgIdAttribute a0 = progId0.children().get(0);
        this.assertFilePosition(27, 30, a0);
        CssParserTest.assertEquals((Object)Name.css("a"), (Object)a0.getName());
        CssTree.Term v0 = a0.getPropertyValue();
        this.assertFilePosition(29, 30, v0);
        CssTree.QuantityLiteral vl0 = (CssTree.QuantityLiteral)v0.getExprAtom();
        this.assertFilePosition(29, 30, vl0);
        CssParserTest.assertEquals((String)"1", (String)vl0.getValue());
        CssTree.Term t1 = e.getNthTerm(1);
        this.assertFilePosition(32, 55, t1);
        CssTree.ProgId progId1 = (CssTree.ProgId)t1.getExprAtom();
        this.assertFilePosition(32, 55, progId1);
        CssParserTest.assertEquals((Object)Name.css("foo.bar.baz"), (Object)progId1.getName());
        CssParserTest.assertEquals((int)1, (int)progId1.children().size());
        CssTree.ProgIdAttribute a1 = progId1.children().get(0);
        this.assertFilePosition(51, 54, a1);
        CssParserTest.assertEquals((Object)Name.css("a"), (Object)a1.getName());
        CssTree.Term v1 = a1.getPropertyValue();
        this.assertFilePosition(53, 54, v1);
        CssTree.QuantityLiteral vl1 = (CssTree.QuantityLiteral)v1.getExprAtom();
        this.assertFilePosition(53, 54, vl1);
        CssParserTest.assertEquals((String)"2", (String)vl1.getValue());
    }

    public final void testUnexpectedErrors() throws Exception {
        this.throwsParseException("div { top:58px\\9;}");
    }

    public final void testErrorMessages() throws Exception {
        this.runTestCssParser(this.fromString("p { color:e# }"), this.fromString(Join.join((CharSequence)"\n", "StyleSheet", "  RuleSet", "    Selector", "      SimpleSelector", "        IdentLiteral : p")), true);
        this.assertMessage(true, MessageType.EXPECTED_TOKEN, MessageLevel.WARNING, MessagePart.Factory.valueOf(";"), MessagePart.Factory.valueOf("#"));
        this.assertMessage(true, MessageType.SKIPPING, MessageLevel.WARNING, new MessagePart[0]);
        this.assertMessagesLessSevereThan(MessageLevel.WARNING);
    }

    private void runTestCssParser(String cssFile, String goldenFile, boolean tolerant) throws Exception {
        this.runTestCssParser(this.fromResource(cssFile), this.fromResource(goldenFile), tolerant);
    }

    private void runTestCssParser(CharProducer css, CharProducer golden, boolean tolerant) throws Exception {
        MessageLevel lvl = tolerant ? MessageLevel.WARNING : MessageLevel.FATAL_ERROR;
        CssTree.StyleSheet stylesheet = new CssParser(CssParser.makeTokenQueue(css.clone(), this.mq, false), this.mq, lvl).parseStyleSheet();
        this.assertCloneable(stylesheet);
        StringBuilder sb = new StringBuilder();
        stylesheet.format(new MessageContext(), sb);
        CssParserTest.assertEquals((String)golden.toString().trim(), (String)sb.toString().trim());
        if (!tolerant) {
            this.runTestCssParser(css, golden.clone(), true);
        }
    }

    private void throwsParseException(String fuzzString) {
        try {
            this.parseString(fuzzString);
        }
        catch (ParseException e) {
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            CssParserTest.fail();
        }
    }

    private CssTree.StyleSheet parseString(String fuzzString) throws Exception {
        return this.css(this.fromString(fuzzString));
    }

    private String renderSnippets(Map<InputSource, String> srcs) {
        SnippetProducer sr = new SnippetProducer(srcs, this.mc, 80);
        ArrayList<Message> messages = new ArrayList<Message>(this.mq.getMessages());
        Collections.sort(messages, new Comparator<Message>(){

            @Override
            public int compare(Message a, Message b) {
                FilePosition fpa = this.firstFilePosition(a.getMessageParts());
                FilePosition fpb = this.firstFilePosition(b.getMessageParts());
                int delta = fpa.startCharInFile() - fpb.startCharInFile();
                if (delta == 0) {
                    delta = fpa.endCharInFile() - fpb.endCharInFile();
                }
                return delta;
            }

            private FilePosition firstFilePosition(List<MessagePart> parts) {
                if (parts.isEmpty()) {
                    return FilePosition.UNKNOWN;
                }
                MessagePart p0 = parts.get(0);
                return p0 instanceof FilePosition ? (FilePosition)p0 : FilePosition.UNKNOWN;
            }
        });
        ArrayList<String> snippets = new ArrayList<String>();
        for (Message msg : messages) {
            snippets.add((Object)((Object)msg.getMessageLevel()) + " : " + msg.format(this.mc));
            snippets.add(sr.getSnippet(msg));
        }
        return Join.join((CharSequence)"\n", snippets);
    }

    private void assertFilePosition(int startCharInFile, int endCharInFile, ParseTreeNode n) {
        FilePosition pos = n.getFilePosition();
        CssParserTest.assertEquals((String)"source", (Object)this.is, (Object)pos.source());
        CssParserTest.assertEquals((String)("start of " + pos), (int)startCharInFile, (int)pos.startCharInFile());
        CssParserTest.assertEquals((String)("end of " + pos), (int)endCharInFile, (int)pos.endCharInFile());
    }
}

