/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.filter.authc;

import java.net.InetAddress;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.UsernamePasswordToken;
import org.jsecurity.subject.Subject;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.filter.authc.AuthenticationFilter;

public abstract class AuthenticatingFilter
extends AuthenticationFilter {
    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        AuthenticationToken token = this.createToken(request, response);
        if (token == null) {
            String msg = "createToken method implementation returned null. A valid non-null AuthenticationToken must be created in order to execute a login attempt.";
            throw new IllegalStateException(msg);
        }
        try {
            Subject subject = this.getSubject(request, response);
            subject.login(token);
            return this.onLoginSuccess(token, subject, request, response);
        }
        catch (AuthenticationException e) {
            return this.onLoginFailure(token, e, request, response);
        }
    }

    protected abstract AuthenticationToken createToken(ServletRequest var1, ServletResponse var2) throws Exception;

    protected AuthenticationToken createToken(String username, String password, ServletRequest request, ServletResponse response) {
        boolean rememberMe = this.isRememberMe(request);
        InetAddress inet = this.getInetAddress(request);
        return this.createToken(username, password, rememberMe, inet);
    }

    protected AuthenticationToken createToken(String username, String password, boolean rememberMe, InetAddress inet) {
        return new UsernamePasswordToken(username, password, rememberMe, inet);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        return true;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        return false;
    }

    protected InetAddress getInetAddress(ServletRequest request) {
        return WebUtils.getInetAddress(request);
    }

    protected boolean isRememberMe(ServletRequest request) {
        return false;
    }
}

