/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupService;
import org.apache.shindig.social.opensocial.spi.UserId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="groups", path="/{userId}")
public class GroupHandler {
    private final GroupService service;

    @Inject
    public GroupHandler(GroupService service) {
        this.service = service;
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        CollectionOptions options = new CollectionOptions((RequestItem)request);
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Only one userId must be specified");
        return this.service.getGroups(userIds.iterator().next(), options, request.getFields(), request.getToken());
    }
}

