/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.swing.explorer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.exoplatform.swing.Application;
import org.exoplatform.swing.JExoTextEditor;
import org.exoplatform.swing.ViewPlugin;

public class ExplorerViewPlugin
extends JPanel
implements ViewPlugin {
    private static DefaultTreeModel tmodel;
    private static FileNode selectFileNode;
    private static JTree jtree;
    private boolean menuItemXmlAdded = false;

    public ExplorerViewPlugin() {
        File[] children;
        this.setName("FileExplorer");
        this.setLayout(new CardLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "ScrollPane");
        jtree = new JTree();
        scrollPane.setViewportView(jtree);
        final File root = new File("/");
        FileNode rootNode = new FileNode(root.getName(), root);
        for (File file : children = root.listFiles()) {
            FileNode fnode = new FileNode(file.getName(), file);
            rootNode.add(fnode);
        }
        tmodel = new DefaultTreeModel(rootNode);
        jtree.setModel(tmodel);
        jtree.getSelectionModel().setSelectionMode(1);
        jtree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                JTree jtree;
                block14: {
                    block12: {
                        String filePath;
                        block13: {
                            System.out.println("==> Tree Action Listener");
                            jtree = (JTree)evt.getSource();
                            if (evt.getPath().getLastPathComponent() == null) {
                                selectFileNode = new FileNode(root.getName(), root);
                            } else {
                                try {
                                    selectFileNode = (FileNode)evt.getPath().getLastPathComponent();
                                    System.out.println("no exception: " + evt.getPath().getLastPathComponent().toString());
                                }
                                catch (Exception ex) {
                                    System.out.println("exception: " + evt.getPath().getLastPathComponent().toString());
                                    ex.printStackTrace();
                                }
                            }
                            if (ExplorerViewPlugin.this.menuItemXmlAdded) {
                                OptionMenu.menuOpenAs.remove(OptionMenu.menuItemXml);
                            }
                            if (!selectFileNode.isLeaf()) break block12;
                            filePath = selectFileNode.getFilePath();
                            if (!filePath.endsWith(".txt")) break block13;
                            try {
                                JInternalFrame frame = Application.getInstance().getWorkspaces().openFrame(filePath);
                                frame.addInternalFrameListener(new InternalFrameAdapter(){

                                    public void internalFrameClosed(InternalFrameEvent e) {
                                        if (selectFileNode.getParent() != null) {
                                            jtree.setSelectionPath(new TreePath(selectFileNode.getParent()));
                                        } else {
                                            jtree.setSelectionPath(new TreePath(null));
                                        }
                                    }
                                });
                                JExoTextEditor textEditor = new JExoTextEditor();
                                textEditor.opentFile(filePath);
                                textEditor.setVisible(true);
                                frame.add(textEditor);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            break block14;
                        }
                        if (!filePath.endsWith(".xml")) break block14;
                        OptionMenu.menuOpenAs.add((Component)OptionMenu.menuItemXml, 1);
                        ExplorerViewPlugin.this.menuItemXmlAdded = true;
                        break block14;
                    }
                    TreePath selectionPaths = null;
                    if (jtree.getSelectionPath() != null) {
                        File selectFile;
                        File[] children;
                        selectionPaths = jtree.getSelectionPath();
                        System.out.println("Selection Path: " + selectionPaths);
                        TreePath parentSelectionPaths = selectionPaths.getParentPath();
                        FileNode parentFileNode = (FileNode)selectFileNode.getParent();
                        if (parentFileNode != null && parentSelectionPaths != null) {
                            Enumeration<TreeNode> e = parentFileNode.children();
                            while (e.hasMoreElements()) {
                                FileNode fnode = (FileNode)e.nextElement();
                                if (fnode == selectFileNode || fnode.isLeaf()) continue;
                                jtree.collapsePath(parentSelectionPaths.pathByAddingChild(fnode));
                            }
                        }
                        if (selectFileNode.getChildCount() <= 0 && (children = (selectFile = new File(selectFileNode.getFilePath())).listFiles()) != null) {
                            for (File file : children) {
                                FileNode fnode = new FileNode(file.getName(), file);
                                selectFileNode.add(fnode);
                            }
                        }
                    }
                }
                jtree.repaint();
                System.out.println("<=== Tree Action Listener");
            }
        });
        final OptionMenu popup = new OptionMenu();
        jtree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    popup.show((JComponent)evt.getSource(), evt.getX(), evt.getY());
                }
            }
        });
    }

    public static JTree getTree() {
        return jtree;
    }

    public String getTitle() {
        return "File Explorer";
    }

    static {
        jtree = null;
    }

    static class OptionMenu
    extends JPopupMenu {
        static JMenuItem menuItemAdmin;
        static JMenuItem menuItemUser;
        static JMenuItem menuItemText;
        static JMenuItem menuItemXml;
        static JMenuItem menuItemDelete;
        static JMenuItem menuItemRename;
        static JMenu menuOpenAs;

        public OptionMenu() {
            this.setPreferredSize(new Dimension(150, 150));
            menuItemAdmin = new JMenuItem("Admin");
            menuItemUser = new JMenuItem("User");
            menuItemText = new JMenuItem("text file    ");
            menuItemXml = new JMenuItem("xml file    ");
            menuOpenAs = new JMenu("Open as  >");
            menuOpenAs.add(menuItemText);
            menuOpenAs.add(menuItemAdmin);
            menuOpenAs.add(menuItemUser);
            this.add(menuOpenAs);
            this.addSeparator();
            menuItemDelete = new JMenuItem("Delete");
            menuItemRename = new JMenuItem("Rename");
            this.add(menuItemDelete);
            this.add(menuItemRename);
            menuItemText.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    OptionMenu.this.openFileAs();
                }
            });
            menuItemXml.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    OptionMenu.this.openFileAs();
                }
            });
            menuItemAdmin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    System.out.println("Admin");
                }
            });
            menuItemUser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    System.out.println("User");
                }
            });
            menuItemDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    int result;
                    if (selectFileNode != null && selectFileNode.getParent() != null && (result = JOptionPane.showConfirmDialog(null, "Are you sure want to delete?", "Confirm", 2, 2)) == 0) {
                        try {
                            System.out.println("file path: " + selectFileNode.getFilePath());
                            File f = new File(selectFileNode.getFilePath());
                            System.out.println("exist: " + f.exists());
                            if (f.isDirectory()) {
                                File[] fileList = f.listFiles();
                                if (fileList.length > 1) {
                                    JOptionPane.showMessageDialog(null, "directory is not empty", "error", 0);
                                } else {
                                    System.out.println("delete :" + f.delete());
                                    tmodel.removeNodeFromParent(selectFileNode);
                                }
                            } else {
                                System.out.println("deleted :" + f.delete());
                                tmodel.removeNodeFromParent(selectFileNode);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
        }

        public void openFileAs() {
            if (selectFileNode.isLeaf()) {
                String filePath = selectFileNode.getFilePath();
                try {
                    JInternalFrame frame = Application.getInstance().getWorkspaces().openFrame(filePath);
                    frame.addInternalFrameListener(new InternalFrameAdapter(){

                        public void internalFrameClosed(InternalFrameEvent e) {
                            if (selectFileNode.getParent() != null) {
                                jtree.setSelectionPath(new TreePath(selectFileNode.getParent()));
                            } else {
                                jtree.setSelectionPath(new TreePath(null));
                            }
                        }
                    });
                    JExoTextEditor textEditor = new JExoTextEditor();
                    textEditor.opentFile(filePath);
                    textEditor.setVisible(true);
                    frame.add(textEditor);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    static class FileNode
    extends DefaultMutableTreeNode {
        private String filePath_;
        private boolean directory_;

        public FileNode(String label, File file) {
            super(label);
            this.filePath_ = file.getAbsolutePath();
            this.directory_ = file.isDirectory();
            if (this.directory_) {
                this.setAllowsChildren(true);
            } else {
                this.setAllowsChildren(false);
            }
        }

        public boolean isLeaf() {
            return !this.directory_;
        }

        public String getFilePath() {
            return this.filePath_;
        }
    }
}

