/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.lifecycle;

import groovy.lang.Closure;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.groovyscript.text.BindingContext;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIContainer;

public class WebuiBindingContext
extends BindingContext {
    protected static Log log = ExoLogger.getLogger((String)"portal:WebuiBindingContext");
    private UIComponent uicomponent_;
    private WebuiRequestContext rcontext_;

    public WebuiBindingContext(ResourceResolver resolver, Writer w, UIComponent uicomponent, final WebuiRequestContext context) {
        super(resolver, w);
        this.uicomponent_ = uicomponent;
        this.rcontext_ = context;
        this.put("nodeurl", new Closure((Object)this){

            public Object call(Object[] args) {
                return context.createURL(NodeURL.TYPE);
            }
        });
        Orientation orientation = context.getOrientation();
        this.put("orientation", orientation);
        this.put("isLT", orientation.isLT());
        this.put("isRT", orientation.isRT());
        this.put("dir", orientation.isLT() ? "ltr" : "rtl");
    }

    public UIComponent getUIComponent() {
        return this.uicomponent_;
    }

    public WebuiRequestContext getRequestContext() {
        return this.rcontext_;
    }

    public String getContextPath() {
        return this.rcontext_.getRequestContextPath();
    }

    public String getPortalContextPath() {
        return this.rcontext_.getPortalContextPath();
    }

    public BindingContext clone() {
        WebuiBindingContext newContext = new WebuiBindingContext(this.resolver_, this.writer_, this.uicomponent_, this.rcontext_);
        newContext.putAll((Map)((Object)this));
        newContext.setGroovyTemplateService(this.service_);
        return newContext;
    }

    public String appRes(String mesgKey) throws Exception {
        String value;
        block3: {
            value = "";
            try {
                ResourceBundle res = this.rcontext_.getApplicationResourceBundle();
                value = res.getString(mesgKey);
            }
            catch (MissingResourceException ex) {
                if (PropertyManager.isDevelopping()) {
                    log.warn((Object)("Can not find resource bundle for key : " + mesgKey));
                }
                if (mesgKey == null) break block3;
                value = mesgKey.substring(mesgKey.lastIndexOf(46) + 1);
            }
        }
        return value;
    }

    public void renderChildren() throws Exception {
        if (this.uicomponent_ instanceof UIComponentDecorator) {
            UIComponentDecorator uiComponentDecorator = (UIComponentDecorator)this.uicomponent_;
            if (uiComponentDecorator.getUIComponent() == null) {
                return;
            }
            uiComponentDecorator.getUIComponent().processRender(this.rcontext_);
            return;
        }
        UIContainer uicontainer = (UIContainer)this.uicomponent_;
        List<UIComponent> children = uicontainer.getChildren();
        for (UIComponent child : children) {
            if (!child.isRendered()) continue;
            child.processRender(this.rcontext_);
        }
    }

    public void renderChild(String id) throws Exception {
        if (!(this.uicomponent_ instanceof UIContainer)) {
            return;
        }
        UIContainer uicontainer = (UIContainer)this.uicomponent_;
        Object uiChild = uicontainer.getChildById(id);
        ((UIComponent)uiChild).processRender(this.rcontext_);
    }

    public void renderUIComponent(UIComponent uicomponent) throws Exception {
        uicomponent.processRender(this.rcontext_);
    }

    public void renderChild(int index) throws Exception {
        if (!(this.uicomponent_ instanceof UIContainer)) {
            return;
        }
        UIContainer uicontainer = (UIContainer)this.uicomponent_;
        Object uiChild = uicontainer.getChild(index);
        ((UIComponent)uiChild).processRender(this.rcontext_);
    }

    public void userRes(String mesgKey) {
    }
}

