/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.i18n;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.gatein.common.i18n.LocaleFormat;
import org.gatein.common.text.CharWriter;
import org.gatein.common.util.ConversionException;

public class CachingLocaleFormat
implements LocaleFormat {
    private final LocaleFormat delegate;
    private final ConcurrentHashMap<String, Locale> localeCache;
    private final ConcurrentHashMap<Locale, String> stringCache;

    public CachingLocaleFormat(LocaleFormat delegate) throws IllegalArgumentException {
        if (delegate == null) {
            throw new IllegalArgumentException("No null delegate is possible");
        }
        this.delegate = delegate;
        this.localeCache = new ConcurrentHashMap();
        this.stringCache = new ConcurrentHashMap();
    }

    public Locale getLocale(String value) throws ConversionException {
        Locale locale = this.localeCache.get(value);
        if (locale != null) {
            return locale;
        }
        locale = this.delegate.getLocale(value);
        this.localeCache.put(value, locale);
        return locale;
    }

    public String toString(Locale locale) throws ConversionException {
        String string = this.stringCache.get(locale);
        if (string != null) {
            return string;
        }
        string = this.delegate.toString(locale);
        this.stringCache.put(locale, string);
        return string;
    }

    public void write(Locale locale, CharWriter writer) throws IOException, ConversionException {
        this.delegate.write(locale, writer);
    }
}

