/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.http.CacheKeyBuilder;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.uri.UriCommon;

public abstract class AbstractHttpCache
implements HttpCache {
    private static final String RESIZE_HEIGHT = UriCommon.Param.RESIZE_HEIGHT.getKey();
    private static final String RESIZE_WIDTH = UriCommon.Param.RESIZE_WIDTH.getKey();
    private static final String RESIZE_QUALITY = UriCommon.Param.RESIZE_QUALITY.getKey();

    protected abstract HttpResponse getResponseImpl(String var1);

    protected abstract void addResponseImpl(String var1, HttpResponse var2);

    protected abstract HttpResponse removeResponseImpl(String var1);

    public final HttpResponse getResponse(HttpRequest request) {
        String keyString;
        HttpResponse cached;
        if (this.isCacheable(request) && this.responseStillUsable(cached = this.getResponseImpl(keyString = this.createKey(request)))) {
            return cached;
        }
        return null;
    }

    public boolean addResponse(HttpRequest request, HttpResponse response) {
        if (this.isCacheable(request, response)) {
            HttpResponseBuilder responseBuilder = new HttpResponseBuilder(response);
            int forcedTtl = request.getCacheTtl();
            if (forcedTtl != -1) {
                responseBuilder.setCacheTtl(forcedTtl);
            }
            response = responseBuilder.create();
            String keyString = this.createKey(request);
            this.addResponseImpl(keyString, response);
            return true;
        }
        return false;
    }

    public HttpResponse removeResponse(HttpRequest request) {
        String keyString = this.createKey(request);
        HttpResponse response = this.getResponseImpl(keyString);
        this.removeResponseImpl(keyString);
        if (this.responseStillUsable(response)) {
            return response;
        }
        return null;
    }

    protected boolean isCacheable(HttpRequest request) {
        if (request.getIgnoreCache()) {
            return false;
        }
        return "GET".equals(request.getMethod()) || "GET".equals(request.getHeader("X-Method-Override"));
    }

    protected boolean isCacheable(HttpRequest request, HttpResponse response) {
        if (!this.isCacheable(request)) {
            return false;
        }
        if (request.getCacheTtl() != -1) {
            return true;
        }
        if (response.getHttpStatusCode() == 304) {
            return false;
        }
        return !response.isStrictNoCache();
    }

    public String createKey(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE && request.getSecurityToken() == null) {
            throw new IllegalArgumentException("Cannot sign request without security token: [" + request + ']');
        }
        CacheKeyBuilder keyBuilder = new CacheKeyBuilder().setLegacyParam(0, request.getUri()).setLegacyParam(1, (Object)request.getAuthType()).setLegacyParam(2, AbstractHttpCache.getOwnerId(request)).setLegacyParam(3, AbstractHttpCache.getViewerId(request)).setLegacyParam(4, AbstractHttpCache.getTokenOwner(request)).setLegacyParam(5, AbstractHttpCache.getAppUrl(request)).setLegacyParam(6, AbstractHttpCache.getInstanceId(request)).setLegacyParam(7, AbstractHttpCache.getServiceName(request)).setLegacyParam(8, AbstractHttpCache.getTokenName(request)).setParam("rh", request.getParam(RESIZE_HEIGHT)).setParam("rw", request.getParam(RESIZE_WIDTH)).setParam("rq", request.getParam(RESIZE_QUALITY)).setParam("rm", request.getRewriteMimeType());
        return keyBuilder.build();
    }

    protected static String getOwnerId(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE && request.getOAuthArguments().getSignOwner()) {
            Preconditions.checkState((request.getSecurityToken() != null ? 1 : 0) != 0, (Object)"No Security Token set for request");
            String ownerId = request.getSecurityToken().getOwnerId();
            return (String)Objects.firstNonNull((Object)ownerId, (Object)"");
        }
        return null;
    }

    protected static String getViewerId(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE && request.getOAuthArguments().getSignViewer()) {
            Preconditions.checkState((request.getSecurityToken() != null ? 1 : 0) != 0, (Object)"No Security Token set for request");
            String viewerId = request.getSecurityToken().getViewerId();
            return (String)Objects.firstNonNull((Object)viewerId, (Object)"");
        }
        return null;
    }

    protected static String getTokenOwner(HttpRequest request) {
        SecurityToken st = request.getSecurityToken();
        if (request.getAuthType() != AuthType.NONE && st.getOwnerId() != null && st.getOwnerId().equals(st.getViewerId()) && request.getOAuthArguments().mayUseToken()) {
            return st.getOwnerId();
        }
        return null;
    }

    protected static String getAppUrl(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE) {
            return request.getSecurityToken().getAppUrl();
        }
        return null;
    }

    protected static String getInstanceId(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE) {
            return Long.toString(request.getSecurityToken().getModuleId());
        }
        return null;
    }

    protected static String getServiceName(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE) {
            return request.getOAuthArguments().getServiceName();
        }
        return null;
    }

    protected static String getTokenName(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE) {
            return request.getOAuthArguments().getTokenName();
        }
        return null;
    }

    protected boolean responseStillUsable(HttpResponse response) {
        return response != null;
    }
}

