/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBClean;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanHelper;
import org.exoplatform.services.jcr.impl.clean.rdbms.IngresSQLDBClean;
import org.exoplatform.services.jcr.impl.clean.rdbms.OracleDBClean;
import org.exoplatform.services.jcr.impl.clean.rdbms.PgSQLDBClean;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;

public class DBCleanService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanWorkspaceData(WorkspaceEntry wsEntry) throws RepositoryConfigurationException, NamingException, SQLException {
        String dsName = wsEntry.getContainer().getParameterValue("source-name");
        final DataSource ds = (DataSource)new InitialContext().lookup(dsName);
        if (ds == null) {
            throw new NameNotFoundException("Data source " + dsName + " not found");
        }
        Connection jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

            @Override
            public Connection run() throws Exception {
                return ds.getConnection();
            }
        });
        jdbcConn.setAutoCommit(false);
        try {
            try {
                DBCleanService.getDBCleaner(jdbcConn, wsEntry).clean();
                jdbcConn.commit();
            }
            catch (SQLException e) {
                jdbcConn.rollback();
                Object var6_5 = null;
                jdbcConn.close();
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            jdbcConn.close();
            throw throwable;
        }
        jdbcConn.close();
    }

    public static void cleanRepositoryData(RepositoryEntry rEntry) throws RepositoryConfigurationException, NamingException, SQLException {
        for (WorkspaceEntry wsEntry : rEntry.getWorkspaceEntries()) {
            DBCleanService.cleanWorkspaceData(wsEntry);
        }
    }

    public static DBClean getDBCleaner(Connection jdbcConn, WorkspaceEntry wsEntry) throws SQLException, RepositoryConfigurationException {
        String deleteItems;
        String selectItems;
        boolean multiDb = Boolean.parseBoolean(wsEntry.getContainer().getParameterValue("multi-db"));
        String containerName = wsEntry.getName();
        String dialect = DialectDetecter.detect(jdbcConn.getMetaData());
        boolean cleanWithHelper = false;
        if (dialect.equals(DBConstants.DB_DIALECT_HSQLDB)) {
            cleanWithHelper = true;
        } else if (dialect.equals(DBConstants.DB_DIALECT_MYSQL) || dialect.equals(DBConstants.DB_DIALECT_MYSQL_UTF8)) {
            String engine;
            cleanWithHelper = true;
            Statement st = jdbcConn.createStatement();
            st.execute("SELECT ENGINE FROM information_schema.TABLES where TABLE_SCHEMA='" + jdbcConn.getCatalog() + "' and (TABLE_NAME='JCR_SITEM' or TABLE_NAME='JCR_MITEM')");
            ResultSet result = st.getResultSet();
            if (result.next() && (engine = result.getString("ENGINE")).equalsIgnoreCase("MyISAM")) {
                cleanWithHelper = false;
            }
        }
        ArrayList<String> cleanScripts = new ArrayList<String>();
        if (multiDb) {
            cleanScripts.add("delete from JCR_MVALUE");
            cleanScripts.add("delete from JCR_MREF");
            if (cleanWithHelper) {
                cleanScripts.add("delete from JCR_MITEM where I_CLASS=2");
                selectItems = "select ID from JCR_MITEM where I_CLASS=1 and PARENT_ID=?";
                deleteItems = "delete from JCR_MITEM where I_CLASS=1 and PARENT_ID=?";
                return new DBClean(jdbcConn, cleanScripts, new DBCleanHelper(jdbcConn, selectItems, deleteItems));
            }
            cleanScripts.add("delete from JCR_MITEM where JCR_MITEM.NAME <> '__root_parent'");
        } else {
            cleanScripts.add("delete from JCR_SVALUE where exists(select * from JCR_SITEM where JCR_SITEM.ID=JCR_SVALUE.PROPERTY_ID and JCR_SITEM.CONTAINER_NAME='" + containerName + "')");
            cleanScripts.add("delete from JCR_SREF where exists(select * from JCR_SITEM where JCR_SITEM.ID=JCR_SREF.PROPERTY_ID and JCR_SITEM.CONTAINER_NAME='" + containerName + "')");
            if (cleanWithHelper) {
                cleanScripts.add("delete from JCR_SITEM where I_CLASS=2 and CONTAINER_NAME='" + containerName + "'");
                selectItems = "select ID from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME='" + containerName + "' and PARENT_ID=?";
                deleteItems = "delete from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME='" + containerName + "' and PARENT_ID=?";
                return new DBClean(jdbcConn, cleanScripts, new DBCleanHelper(jdbcConn, selectItems, deleteItems));
            }
            cleanScripts.add("delete from JCR_SITEM where CONTAINER_NAME='" + containerName + "'");
        }
        if (dialect.equals(DBConstants.DB_DIALECT_PGSQL)) {
            return new PgSQLDBClean(jdbcConn, cleanScripts);
        }
        if (dialect.equals(DBConstants.DB_DIALECT_INGRES)) {
            return new IngresSQLDBClean(jdbcConn, cleanScripts);
        }
        if (dialect.equals(DBConstants.DB_DIALECT_ORACLE) || dialect.equals(DBConstants.DB_DIALECT_ORACLEOCI)) {
            return new OracleDBClean(jdbcConn, cleanScripts);
        }
        return new DBClean(jdbcConn, cleanScripts);
    }
}

