/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.GenericCQConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.PostgreMultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.PostgreSingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class PostgreConnectionFactory
extends GenericCQConnectionFactory {
    public PostgreConnectionFactory(String dbDriver, String dbUrl, String dbUserName, String dbPassword, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws RepositoryException {
        super(dbDriver, dbUrl, dbUserName, dbPassword, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    public PostgreConnectionFactory(DataSource dbDataSource, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) {
        super(dbDataSource, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.multiDb) {
                return new PostgreMultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerName, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            return new PostgreSingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerName, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isReindexingSupport() {
        return true;
    }
}

