/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageTemplateOptions;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputItemSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormPopupWindow;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.organization.UIGroupMembershipSelector;
import org.exoplatform.webui.organization.UIListPermissionSelector;
import org.exoplatform.webui.organization.UIPermissionSelector;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ChangeOwnerTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectMembershipActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeOwnerIdActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE)}, initParams={@ParamConfig(name="PageTemplate", value="system:/WEB-INF/conf/uiconf/portal/webui/page/PageTemplate.groovy")}), @ComponentConfig(type=UIFormInputSet.class, id="PermissionSetting", template="system:/groovy/webui/core/UITabSelector.gtmpl", events={@EventConfig(listeners={UIFormInputSet.SelectComponentActionListener.class})})})
public class UIPageForm
extends UIFormTabPane {
    private UIPage uiPage_;
    protected UIFormInputSet uiPermissionSetting;
    protected UIFormSelectBox groupIdSelectBox = null;
    protected UIFormStringInput ownerIdInput = null;
    public static final String OWNER_TYPE = "ownerType";
    public static final String OWNER_ID = "ownerId";

    public UIPageForm(InitParams initParams) throws Exception {
        super("UIPageForm");
        this.setActions(new String[]{"Save", "Close"});
    }

    public UIPage getUIPage() {
        return this.uiPage_;
    }

    @Deprecated
    public void setValues(UIPage uiPage) throws Exception {
        this.buildForm(uiPage);
    }

    public void invokeSetBindingBean(Object bean) throws Exception {
        UIPageTemplateOptions uiConfigOptions;
        SelectItemOption itemOption;
        String ownerType = (String)this.getUIFormSelectBox(OWNER_TYPE).getValue();
        String ownerId = (String)this.getUIStringInput(OWNER_ID).getValue();
        if (SiteType.GROUP.getName().equals(ownerType) && ownerId.charAt(0) != '/') {
            ownerId = "/" + ownerId;
        }
        Page page = (Page)bean;
        page.setPageId((String)this.getUIStringInput("pageId").getValue());
        page.setOwnerType(ownerType);
        page.setOwnerId(ownerId);
        page.setName((String)this.getUIStringInput("name").getValue());
        String title = (String)this.getUIStringInput("title").getValue();
        if (title == null || title.trim().length() < 1) {
            title = page.getName();
        }
        page.setTitle(title);
        if (!page.isShowMaxWindow()) {
            page.setShowMaxWindow((Boolean)this.getUIFormCheckBoxInput("showMaxWindow").getValue());
        }
        if (!SiteType.USER.getName().equals(page.getOwnerType())) {
            page.setAccessPermissions(((UIListPermissionSelector)this.uiPermissionSetting.getChild(UIListPermissionSelector.class)).getValue());
            page.setEditPermission(((UIPermissionSelector)this.uiPermissionSetting.getChild(UIPermissionSelector.class)).getValue());
        }
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        userACL.hasPermission(page);
        UIFormInputItemSelector uiTemplate = (UIFormInputItemSelector)this.getChildById("Template");
        if (uiTemplate != null && (itemOption = uiTemplate.getSelectedItemOption()) != null) {
            page.setFactoryId(itemOption.getIcon());
        }
        if ((uiConfigOptions = (UIPageTemplateOptions)this.getChild(UIPageTemplateOptions.class)) == null) {
            return;
        }
        Page selectedPage = uiConfigOptions.createPageFromSelectedOption(page.getOwnerType(), page.getOwnerId());
        if (selectedPage == null) {
            return;
        }
        page.setChildren(selectedPage.getChildren());
        page.setFactoryId(selectedPage.getFactoryId());
    }

    private void loadMakableGroupNavigations() throws Exception {
        if (this.groupIdSelectBox == null) {
            UIFormInputSet uiSettingSet = (UIFormInputSet)this.getChildById("PageSetting");
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
            List groups = userPortalConfigService.getMakableNavigations(pcontext.getRemoteUser(), true);
            if (groups.size() > 0) {
                Collections.sort(groups);
                ArrayList<SelectItemOption> groupsItem = new ArrayList<SelectItemOption>();
                for (String group : groups) {
                    groupsItem.add(new SelectItemOption((Object)group));
                }
                this.groupIdSelectBox = new UIFormSelectBox(OWNER_ID, OWNER_ID, groupsItem);
                this.groupIdSelectBox.setOnChange("ChangeOwnerId");
                this.groupIdSelectBox.setParent((UIComponent)uiSettingSet);
            }
        }
    }

    public void buildForm(UIPage uiPage) throws Exception {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        PortalConfig pConfig = dataStorage.getPortalConfig(pcontext.getPortalOwner());
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserACL acl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
        UIFormInputSet uiSettingSet = new UIFormInputSet("PageSetting");
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput("pageId", "pageId", null).setEditable(false));
        ArrayList<SelectItemOption> ownerTypes = new ArrayList<SelectItemOption>();
        if (pConfig != null && acl.hasEditPermission(pConfig)) {
            ownerTypes.add(new SelectItemOption((Object)SiteType.PORTAL.getName()));
        }
        ownerTypes.add(new SelectItemOption((Object)SiteType.GROUP.getName()));
        ownerTypes.add(new SelectItemOption((Object)SiteType.USER.getName()));
        UIFormSelectBox uiSelectBoxOwnerType = new UIFormSelectBox(OWNER_TYPE, OWNER_TYPE, ownerTypes);
        uiSelectBoxOwnerType.setOnChange("ChangeOwnerType");
        uiSettingSet.addUIFormInput((UIFormInput)uiSelectBoxOwnerType);
        this.ownerIdInput = new UIFormStringInput(OWNER_ID, OWNER_ID, null);
        this.ownerIdInput.setEditable(false).setValue((Object)pcontext.getRemoteUser());
        uiSettingSet.addUIFormInput((UIFormInput)this.ownerIdInput);
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput("name", "name", null).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(IdentifierValidator.class, new Object[0]).addValidator(MandatoryValidator.class, new Object[0])).addUIFormInput((UIFormInput)new UIFormStringInput("title", "title", null).addValidator(StringLengthValidator.class, new Object[]{3, 120})).addUIFormInput((UIFormInput)new UIFormCheckBoxInput("showMaxWindow", "showMaxWindow", (Object)false));
        this.addUIFormInput(uiSettingSet);
        this.setSelectedTab(uiSettingSet.getId());
        if (uiPage == null) {
            UIPageTemplateOptions uiTemplateConfig = (UIPageTemplateOptions)this.createUIComponent(UIPageTemplateOptions.class, null, null);
            this.addUIFormInput((UIFormInput)uiTemplateConfig);
        }
        if (uiPage == null || !uiPage.getSiteKey().getType().equals((Object)SiteType.USER) && this.getChildById("PermissionSetting") == null) {
            this.uiPermissionSetting = (UIFormInputSet)this.createUIComponent(UIFormInputSet.class, "PermissionSetting", null);
            UIListPermissionSelector uiListPermissionSelector = (UIListPermissionSelector)this.createUIComponent(UIListPermissionSelector.class, null, null);
            uiListPermissionSelector.configure("UIListPermissionSelector", "accessPermissions");
            uiListPermissionSelector.addValidator(UIListPermissionSelector.EmptyIteratorValidator.class, new Object[0]);
            this.uiPermissionSetting.addChild((UIComponent)uiListPermissionSelector);
            this.uiPermissionSetting.setSelectedComponent(uiListPermissionSelector.getId());
            UIPermissionSelector uiEditPermission = (UIPermissionSelector)this.createUIComponent(UIPermissionSelector.class, null, null);
            uiEditPermission.setRendered(false);
            uiEditPermission.addValidator(UIPermissionSelector.MandatoryValidator.class, new Object[0]);
            uiEditPermission.setEditable(false);
            uiEditPermission.configure("UIPermissionSelector", "editPermission");
            this.uiPermissionSetting.addChild((UIComponent)uiEditPermission);
            ((UIFormPopupWindow)uiListPermissionSelector.getChild(UIFormPopupWindow.class)).setId("UIPageFormPopupGroupMembershipSelector");
            this.addUIFormInput(this.uiPermissionSetting);
            ((UIPermissionSelector)this.uiPermissionSetting.getChild(UIPermissionSelector.class)).setEditable(true);
        }
        if (uiPage != null) {
            this.uiPage_ = uiPage;
            Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
            this.invokeGetBindingBean(page);
            this.getUIStringInput("name").setEditable(false);
            this.getUIStringInput("pageId").setValue((Object)uiPage.getPageId());
            this.getUIStringInput("title").setValue((Object)uiPage.getTitle());
            this.getUIFormCheckBoxInput("showMaxWindow").setValue((Object)uiPage.isShowMaxWindow());
            this.getUIFormSelectBox(OWNER_TYPE).setEnable(false).setValue((Object)uiPage.getSiteKey().getTypeName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectMembershipActionListener
    extends EventListener<UIGroupMembershipSelector> {
        public void execute(Event<UIGroupMembershipSelector> event) throws Exception {
            UIPageForm uiForm = (UIPageForm)((UIGroupMembershipSelector)event.getSource()).getAncestorOfType(UIPageForm.class);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeOwnerIdActionListener
    extends EventListener<UIPageForm> {
        public void execute(Event<UIPageForm> event) throws Exception {
            UIPageForm uiForm = (UIPageForm)((Object)event.getSource());
            String groupIdSelected = (String)uiForm.groupIdSelectBox.getValue();
            groupIdSelected = groupIdSelected.startsWith("/") ? groupIdSelected : "/" + groupIdSelected;
            String permission = "*:" + groupIdSelected;
            ((UIListPermissionSelector)uiForm.findFirstComponentOfType(UIListPermissionSelector.class)).setValue(new String[]{permission});
            UserACL userACL = (UserACL)uiForm.getApplicationComponent(UserACL.class);
            permission = userACL.getMakableMT() + ":" + groupIdSelected;
            ((UIPermissionSelector)uiForm.findFirstComponentOfType(UIPermissionSelector.class)).setValue(permission);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeOwnerTypeActionListener
    extends EventListener<UIPageForm> {
        public void execute(Event<UIPageForm> event) throws Exception {
            UIPageForm uiForm = (UIPageForm)((Object)event.getSource());
            UIFormSelectBox uiSelectBox = uiForm.getUIFormSelectBox(UIPageForm.OWNER_TYPE);
            String ownerType = (String)uiSelectBox.getValue();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIFormInputSet uiSettingSet = (UIFormInputSet)uiForm.getChildById("PageSetting");
            uiForm.setSelectedTab("PageSetting");
            List list = uiSettingSet.getChildren();
            if (SiteType.PORTAL.getName().equals(ownerType)) {
                list.remove(2);
                list.add(2, uiForm.ownerIdInput);
                uiForm.ownerIdInput.setValue((Object)prContext.getPortalOwner());
                ((UIListPermissionSelector)uiForm.findFirstComponentOfType(UIListPermissionSelector.class)).setValue(Util.getUIPortal().getAccessPermissions());
                ((UIPermissionSelector)uiForm.findFirstComponentOfType(UIPermissionSelector.class)).setValue(Util.getUIPortal().getEditPermission());
            } else {
                list.remove(2);
                uiForm.loadMakableGroupNavigations();
                list.add(2, uiForm.groupIdSelectBox);
                String groupIdSelected = (String)uiForm.groupIdSelectBox.getValue();
                groupIdSelected = groupIdSelected.startsWith("/") ? groupIdSelected : "/" + groupIdSelected;
                String permission = "*:" + groupIdSelected;
                ((UIListPermissionSelector)uiForm.findFirstComponentOfType(UIListPermissionSelector.class)).setValue(new String[]{permission});
                UserACL userACL = (UserACL)uiForm.getApplicationComponent(UserACL.class);
                permission = userACL.getMakableMT() + ":" + groupIdSelected;
                ((UIPermissionSelector)uiForm.findFirstComponentOfType(UIPermissionSelector.class)).setValue(permission);
            }
            prContext.addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPageForm> {
        public void execute(Event<UIPageForm> event) throws Exception {
            UIPageForm uiPageForm = (UIPageForm)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageForm.getAncestorOfType(UIPortalApplication.class);
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            UIPage uiPage = uiPageForm.getUIPage();
            if (uiPage == null) {
                return;
            }
            Page page = new Page();
            uiPageForm.invokeSetBindingBean(page);
            uiPage.setAccessPermissions(page.getAccessPermissions());
            uiPage.setEditPermission(page.getEditPermission());
            uiPage.setTitle(page.getTitle());
            uiPage.setShowMaxWindow(page.isShowMaxWindow());
            uiMaskWS.setUIComponent(null);
            uiMaskWS.setShow(false);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            pcontext.getJavascriptManager().addJavascript((CharSequence)"eXo.portal.UIPortal.changeComposerSaveButton();");
        }
    }
}

