/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common.collection.delta;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.chromattic.common.collection.delta.AbstractInsertionSegment;
import org.chromattic.common.collection.delta.HeadSegment;
import org.chromattic.common.collection.delta.InPlaceSegment;
import org.chromattic.common.collection.delta.ListAdapter;
import org.chromattic.common.collection.delta.Segment;
import org.chromattic.common.collection.delta.TailSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeltaList<E, L>
implements List<E> {
    private Segment<E> head;
    private Segment<E> tail;
    private final L list;
    private final ListAdapter<E, L> adapter;

    public static <E> List<E> create(List<E> list) {
        ListAdapter adapter = new ListAdapter<E, List<E>>(){

            @Override
            public E get(List<E> list, int index) {
                return list.get(index);
            }

            @Override
            public int size(List<E> list) {
                return list.size();
            }

            @Override
            public void remove(List<E> list, int from, int to) {
                list.subList(from, to).clear();
            }

            @Override
            public void insert(List<E> list, int index, List<E> elements) {
                list.addAll(index, elements);
            }
        };
        return new DeltaList<E, List<E>>(adapter, list);
    }

    private DeltaList(ListAdapter<E, L> adapter, L list) {
        InPlaceSegment segment = new InPlaceSegment(this);
        segment.listIndex = 0;
        segment.listSize = adapter.size(list);
        HeadSegment head = new HeadSegment();
        TailSegment tail = new TailSegment();
        head.addAfter(segment).addAfter(tail);
        this.list = list;
        this.adapter = adapter;
        this.head = head;
        this.tail = tail;
    }

    E listget(int index) {
        return this.adapter.get(this.list, index);
    }

    public void save() {
        int index = 0;
        for (Segment<E> segment = this.head; segment != null; segment = segment.getNext()) {
            if (segment instanceof InPlaceSegment) {
                InPlaceSegment inPlaceSegment = (InPlaceSegment)segment;
                if (index < inPlaceSegment.listIndex) {
                    this.adapter.remove(this.list, index, inPlaceSegment.listIndex);
                }
                index += inPlaceSegment.listSize;
                continue;
            }
            AbstractInsertionSegment insertionSegment = (AbstractInsertionSegment)segment;
            int inSize = insertionSegment.insertions.size();
            if (inSize <= 0) continue;
            this.adapter.insert(this.list, index, insertionSegment.insertions);
            index += inSize;
        }
        int size = this.adapter.size(this.list);
        if (index < size) {
            this.adapter.remove(this.list, index, size);
        }
    }

    public int complexity() {
        return this.head.complexity();
    }

    @Override
    public E get(int index) {
        return this.head.get(index);
    }

    @Override
    public void add(int index, E e) {
        this.head.add(index, e);
    }

    @Override
    public E remove(int index) {
        return this.head.remove(index);
    }

    @Override
    public int size() {
        return this.head.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.head.iterator();
    }

    public String toString() {
        return this.head.format();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

