/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shindig.common.util.Base32;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.LockedDomainService;

@Singleton
public class HashLockedDomainService
implements LockedDomainService {
    private static final Logger LOG = Logger.getLogger(HashLockedDomainService.class.getName());
    private final boolean enabled;
    private boolean lockSecurityTokens = false;
    private final Map<String, String> lockedSuffixes;
    private final Map<String, Boolean> required;
    public static final String LOCKED_DOMAIN_REQUIRED_KEY = "gadgets.lockedDomainRequired";
    public static final String LOCKED_DOMAIN_SUFFIX_KEY = "gadgets.lockedDomainSuffix";

    @Inject
    public HashLockedDomainService(ContainerConfig config, @Named(value="shindig.locked-domain.enabled") boolean enabled) {
        this.enabled = enabled;
        this.lockedSuffixes = Maps.newHashMap();
        this.required = Maps.newHashMap();
        Collection containers = config.getContainers();
        if (enabled) {
            for (String container : containers) {
                String suffix = config.getString(container, LOCKED_DOMAIN_SUFFIX_KEY);
                if (suffix == null) {
                    LOG.warning("No locked domain configuration for " + container);
                } else {
                    this.lockedSuffixes.put(container, suffix);
                }
                this.required.put(container, config.getBool(container, LOCKED_DOMAIN_REQUIRED_KEY));
            }
        }
    }

    @Inject(optional=true)
    public void setLockSecurityTokens(@Named(value="shindig.locked-domain.lock-security-tokens") Boolean lockSecurityTokens) {
        this.lockSecurityTokens = lockSecurityTokens;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSafeForOpenProxy(String host) {
        if (this.enabled) {
            return !this.hostRequiresLockedDomain(host);
        }
        return true;
    }

    public boolean gadgetCanRender(String host, Gadget gadget, String container) {
        container = this.normalizeContainer(container);
        if (this.enabled && (this.gadgetWantsLockedDomain(gadget) || this.hostRequiresLockedDomain(host) || this.containerRequiresLockedDomain(container))) {
            String neededHost = this.getLockedDomain(gadget, container);
            return host.equals(neededHost);
        }
        return true;
    }

    public String getLockedDomainForGadget(Gadget gadget, String container) {
        container = this.normalizeContainer(container);
        if (this.enabled && (this.gadgetWantsLockedDomain(gadget) || this.containerRequiresLockedDomain(container))) {
            return this.getLockedDomain(gadget, container);
        }
        return null;
    }

    private String getLockedDomain(Gadget gadget, String container) {
        String suffix = this.lockedSuffixes.get(container);
        if (suffix == null) {
            return null;
        }
        byte[] sha1 = DigestUtils.sha((String)gadget.getSpec().getUrl().toString());
        String hash = new String(Base32.encodeBase32((byte[])sha1));
        return hash + suffix;
    }

    private boolean gadgetWantsLockedDomain(Gadget gadget) {
        if (this.lockSecurityTokens) {
            return gadget.getAllFeatures().contains("locked-domain");
        }
        return gadget.getSpec().getModulePrefs().getFeatures().keySet().contains("locked-domain");
    }

    private boolean hostRequiresLockedDomain(String host) {
        for (String suffix : this.lockedSuffixes.values()) {
            if (!host.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private boolean containerRequiresLockedDomain(String container) {
        return this.required.get(container);
    }

    private String normalizeContainer(String container) {
        if (this.required.containsKey(container)) {
            return container;
        }
        return "default";
    }
}

