/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.SortComparator;
import org.exoplatform.services.jcr.impl.core.query.lucene.ComparableBoolean;
import org.exoplatform.services.jcr.impl.core.query.lucene.DateField;
import org.exoplatform.services.jcr.impl.core.query.lucene.DoubleField;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.LongField;
import org.exoplatform.services.jcr.impl.core.query.lucene.PropertyMetaData;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;

public class SharedFieldCache {
    public static final SharedFieldCache INSTANCE = new SharedFieldCache();
    private final Map cache = new WeakHashMap();

    private SharedFieldCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueIndex getValueIndex(IndexReader reader, String field, String prefix, SortComparator comparator) throws IOException {
        ValueIndex ret;
        if (reader instanceof ReadOnlyIndexReader) {
            reader = ((ReadOnlyIndexReader)reader).getBase();
        }
        if ((ret = this.lookup((IndexReader)reader, field = field.intern(), prefix, comparator)) == null) {
            Comparable[] retArray = new Comparable[reader.maxDoc()];
            int setValues = 0;
            if (retArray.length > 0) {
                TermPositions termDocs;
                IndexFormatVersion version = IndexFormatVersion.getVersion(reader);
                boolean hasPayloads = version.isAtLeast(IndexFormatVersion.V3);
                byte[] payload = null;
                if (hasPayloads) {
                    termDocs = reader.termPositions();
                    payload = new byte[1];
                } else {
                    termDocs = reader.termDocs();
                }
                TermEnum termEnum = reader.terms(new Term(field, prefix));
                char[] tmp = new char[16];
                try {
                    Term term;
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + field);
                    }
                    while ((term = termEnum.term()).field() == field && term.text().startsWith(prefix)) {
                        String text = term.text();
                        int len = text.length() - prefix.length();
                        if (tmp.length < len) {
                            tmp = new char[len];
                        }
                        text.getChars(prefix.length(), text.length(), tmp, 0);
                        String value = new String(tmp, 0, len);
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            int type = 0;
                            if (hasPayloads) {
                                TermPositions termPos = termDocs;
                                termPos.nextPosition();
                                if (termPos.isPayloadAvailable()) {
                                    payload = termPos.getPayload(payload, 0);
                                    type = PropertyMetaData.fromByteArray(payload).getPropertyType();
                                }
                            }
                            ++setValues;
                            retArray[termDocs.doc()] = this.getValue(value, type);
                        }
                        if (termEnum.next()) continue;
                        break;
                    }
                    Object var21_20 = null;
                }
                catch (Throwable throwable) {
                    Object var21_21 = null;
                    termDocs.close();
                    termEnum.close();
                    throw throwable;
                }
                termDocs.close();
                termEnum.close();
                {
                }
            }
            ValueIndex value = new ValueIndex(retArray, setValues);
            this.store((IndexReader)reader, field, prefix, comparator, value);
            return value;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueIndex lookup(IndexReader reader, String field, String prefix, SortComparator comparer) {
        Key key = new Key(field, prefix, comparer);
        SharedFieldCache sharedFieldCache = this;
        synchronized (sharedFieldCache) {
            HashMap readerCache = (HashMap)this.cache.get(reader);
            if (readerCache == null) {
                return null;
            }
            return (ValueIndex)readerCache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object store(IndexReader reader, String field, String prefix, SortComparator comparer, ValueIndex value) {
        Key key = new Key(field, prefix, comparer);
        SharedFieldCache sharedFieldCache = this;
        synchronized (sharedFieldCache) {
            HashMap<Key, ValueIndex> readerCache = (HashMap<Key, ValueIndex>)this.cache.get(reader);
            if (readerCache == null) {
                readerCache = new HashMap<Key, ValueIndex>();
                this.cache.put(reader, readerCache);
            }
            return readerCache.put(key, value);
        }
    }

    private Comparable getValue(String value, int type) {
        switch (type) {
            case 6: {
                return ComparableBoolean.valueOf(Boolean.valueOf(value));
            }
            case 5: {
                return new Long(DateField.stringToTime(value));
            }
            case 3: {
                return new Long(LongField.stringToLong(value));
            }
            case 4: {
                return new Double(DoubleField.stringToDouble(value));
            }
        }
        return value;
    }

    static class Key {
        private final String field;
        private final String prefix;
        private final SortComparator comparator;

        Key(String field, String prefix, SortComparator comparator) {
            this.field = field.intern();
            this.prefix = prefix.intern();
            this.comparator = comparator;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return other.field == this.field && other.prefix == this.prefix && other.comparator.equals(this.comparator);
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.prefix.hashCode() ^ this.comparator.hashCode();
        }
    }

    public static class ValueIndex {
        private static final int SPARSE_FACTOR = 100;
        private final Comparable[] values;
        public final Map valuesMap;
        public final boolean sparse;

        public ValueIndex(Comparable[] values, int setValues) {
            if (this.isSparse(values, setValues)) {
                this.sparse = true;
                this.values = null;
                this.valuesMap = setValues == 0 ? null : this.getValuesMap(values, setValues);
            } else {
                this.sparse = false;
                this.values = values;
                this.valuesMap = null;
            }
        }

        public Comparable getValue(int i) {
            if (this.sparse) {
                return this.valuesMap == null ? null : (Comparable)this.valuesMap.get(new Integer(i));
            }
            return this.values[i];
        }

        private Map getValuesMap(Comparable[] values, int setValues) {
            HashMap<Integer, Comparable> map = new HashMap<Integer, Comparable>(setValues);
            for (int i = 0; i < values.length && setValues > 0; ++i) {
                if (values[i] == null) continue;
                map.put(new Integer(i), values[i]);
                --setValues;
            }
            return map;
        }

        private boolean isSparse(Comparable[] values, int setValues) {
            return setValues * 100 < values.length;
        }
    }
}

