/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.Content;
import com.google.caja.ancillary.servlet.UriFetcher;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.HtmlQuasiBuilder;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Lists;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

final class UploadPage {
    UploadPage() {
    }

    static void doUpload(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        List<ObjectConstructor> uploads = Lists.newArrayList();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            List items;
            DiskFileItemFactory factory = new DiskFileItemFactory();
            int maxUploadSizeBytes = 262144;
            factory.setSizeThreshold(maxUploadSizeBytes);
            factory.setRepository(new File("/dev/null"));
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax((long)maxUploadSizeBytes);
            UploadPage.writeHeader(resp);
            try {
                items = upload.parseRequest(req);
            }
            catch (FileUploadException ex) {
                ex.printStackTrace();
                resp.getWriter().write(Nodes.encode(ex.getMessage()));
                return;
            }
            for (Object fileItemObj : items) {
                FileItem item = (FileItem)fileItemObj;
                if (item.isFormField()) continue;
                FilePosition unk = FilePosition.UNKNOWN;
                String ct = item.getContentType();
                uploads.add((ObjectConstructor)QuasiBuilder.substV("({ i: @i, ip: @ip, it: @it? })", "i", StringLiteral.valueOf(unk, item.getString()), "ip", StringLiteral.valueOf(unk, item.getName()), "it", ct != null ? StringLiteral.valueOf(unk, ct) : null));
            }
        } else if (req.getParameter("url") != null) {
            List<URI> toFetch = Lists.newArrayList();
            boolean failed = false;
            for (String value : req.getParameterValues("url")) {
                try {
                    toFetch.add(new URI(value));
                }
                catch (URISyntaxException ex) {
                    if (!failed) {
                        failed = true;
                        resp.setStatus(500);
                        resp.setContentType("text/html;charset=UTF-8");
                    }
                    resp.getWriter().write("<p>Bad URI: " + Nodes.encode(ex.getMessage()));
                }
            }
            if (failed) {
                return;
            }
            UploadPage.writeHeader(resp);
            FilePosition unk = FilePosition.UNKNOWN;
            for (URI uri : toFetch) {
                try {
                    Content c = UriFetcher.fetch(uri);
                    if (!c.isText()) continue;
                    uploads.add((ObjectConstructor)QuasiBuilder.substV("({ i: @i, ip: @ip, it: @it? })", "i", StringLiteral.valueOf(unk, c.getText()), "ip", StringLiteral.valueOf(unk, uri.toString()), "it", StringLiteral.valueOf(unk, c.type.mimeType)));
                }
                catch (IOException ex) {
                    resp.getWriter().write("<p>" + Nodes.encode("Failed to fetch URI: " + uri + " : " + ex.getMessage()));
                }
            }
        } else {
            resp.setStatus(400);
            resp.getWriter().write("Content not multipart");
            return;
        }
        Expression notifyParent = (Expression)QuasiBuilder.substV("window.parent.uploaded([@uploads*], window.name)", "uploads", new ParseTreeNodeContainer(uploads));
        StringBuilder jsBuf = new StringBuilder();
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(jsBuf))).withEmbeddable(true);
        notifyParent.render(rc);
        rc.getOut().noMoreTokens();
        HtmlQuasiBuilder b = HtmlQuasiBuilder.getBuilder(DomParser.makeDocument(null, null));
        PrintWriter out = resp.getWriter();
        ((Writer)out).write(Nodes.render(b.substV("<script>@js</script>", "js", jsBuf.toString())));
    }

    private static void writeHeader(HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setContentType("text/html;charset=UTF-8");
        PrintWriter out = resp.getWriter();
        ((Writer)out).write("<h1>Loading&hellip;</h1>");
        ((Writer)out).flush();
    }
}

