/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.SwitchCase;
import com.google.caja.reporting.RenderContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwitchStmt
extends LabeledStatement {
    @ParseTreeNode.ReflectiveCtor
    public SwitchStmt(FilePosition pos, String label, List<? extends ParseTreeNode> children) {
        super(pos, label, ParseTreeNode.class);
        this.createMutation().appendChildren(children).execute();
    }

    public SwitchStmt(FilePosition pos, String label, Expression valueExpr, List<SwitchCase> cases) {
        super(pos, label, ParseTreeNode.class);
        this.createMutation().appendChild(valueExpr).appendChildren(cases).execute();
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        List<? extends ParseTreeNode> children = this.children();
        ParseTreeNode valueExpr = children.get(0);
        if (!(valueExpr instanceof Expression)) {
            throw new ClassCastException("Expected " + Expression.class.getName() + " not " + valueExpr.getClass().getName());
        }
        for (ParseTreeNode parseTreeNode : children.subList(1, children.size())) {
            if (parseTreeNode instanceof SwitchCase) continue;
            throw new ClassCastException("Expected " + SwitchCase.class.getName() + " not " + (parseTreeNode != null ? parseTreeNode.getClass().getName() : "<null>"));
        }
    }

    @Override
    public void continues(Map<String, List<ContinueStmt>> contsReaching) {
        for (ParseTreeNode parseTreeNode : this.children()) {
            if (!(parseTreeNode instanceof Statement)) continue;
            ((Statement)parseTreeNode).continues(contsReaching);
        }
    }

    @Override
    public boolean isTargetForContinue() {
        return false;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        String label = this.getRenderedLabel(rc);
        if (null != label) {
            out.consume(label);
            out.consume(":");
        }
        Iterator<? extends ParseTreeNode> it = this.children().iterator();
        out.consume("switch");
        out.consume("(");
        it.next().render(rc);
        out.consume(")");
        out.consume("{");
        while (it.hasNext()) {
            SwitchCase caseStmt = (SwitchCase)it.next();
            caseStmt.render(rc);
        }
        out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
        out.consume("}");
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public boolean hasHangingConditional() {
        return false;
    }
}

