/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.resolver.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResourceResolver
extends ResourceResolver {
    static String FILE_PREFIX = "file:";

    @Override
    public URL getResource(String url) throws Exception {
        String path = this.removeScheme(url);
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            return file.toURL();
        }
        return null;
    }

    @Override
    public InputStream getInputStream(String url) throws Exception {
        String path = this.removeScheme(url);
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            FileInputStream is = new FileInputStream(file);
            return is;
        }
        return null;
    }

    @Override
    public List<URL> getResources(String url) throws Exception {
        ArrayList<URL> urlList = new ArrayList<URL>();
        urlList.add(this.getResource(url));
        return urlList;
    }

    @Override
    public List<InputStream> getInputStreams(String url) throws Exception {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        inputStreams.add(this.getInputStream(url));
        return inputStreams;
    }

    @Override
    public String getRealPath(String url) {
        String path = this.removeScheme(url);
        return path;
    }

    @Override
    public boolean isModified(String url, long lastAccess) {
        File file = new File(this.getRealPath(url));
        return file.exists() && file.lastModified() > lastAccess;
    }

    @Override
    public String getResourceScheme() {
        return "file:";
    }
}

