/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.distribution.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.ext.distribution.impl.AbstractDataDistributionType;
import org.exoplatform.services.jcr.impl.core.NodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDistributionByName
extends AbstractDataDistributionType {
    private int depth = 4;
    private String suffix = "___";

    @Override
    protected List<String> getAncestors(String dataId) {
        ArrayList<String> result = new ArrayList<String>(this.depth);
        int length = dataId.length();
        for (int i = 0; i < this.depth - 1 && i < length - 1; ++i) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(dataId, 0, i + 1);
            buffer.append(this.suffix);
            result.add(buffer.toString());
        }
        result.add(dataId);
        return result;
    }

    @Override
    protected boolean useParametersOnLeafOnly() {
        return true;
    }

    @Override
    public void migrate(Node rootNode) throws RepositoryException {
        this.migrate(rootNode, null, null, null);
    }

    @Override
    public void migrate(Node rootNode, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws RepositoryException {
        NodeIterator iter = ((NodeImpl)rootNode).getNodesLazily(1);
        while (iter.hasNext()) {
            String userName = iter.nextNode().getName();
            if (userName.length() == 1) continue;
            if (!userName.endsWith(this.suffix) && iter.hasNext()) break;
            return;
        }
        iter = ((NodeImpl)rootNode).getNodesLazily();
        while (iter.hasNext()) {
            Node userNode = iter.nextNode();
            if (userNode.getName().length() == 1) continue;
            List<String> ancestors = this.getAncestors(userNode.getName());
            Node node = rootNode;
            int length = ancestors.size() - 1;
            for (int i = 0; i < length; ++i) {
                String nodeName = ancestors.get(i);
                try {
                    node = node.getNode(nodeName);
                    continue;
                }
                catch (PathNotFoundException e) {
                    node = this.createNode(node, nodeName, nodeType, mixinTypes, permissions, false, false);
                }
            }
            userNode.getSession().move(userNode.getPath(), node.getPath() + "/" + ancestors.get(ancestors.size() - 1));
        }
        rootNode.getSession().save();
    }
}

