/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;

public class SynchronousMessageSpeedTest {
    Channel channel;
    String props = null;
    boolean server = false;
    int num = 1000;
    int received = 0;
    static final long TIMEOUT = 10000L;

    public SynchronousMessageSpeedTest(String props, boolean server, int num) {
        this.props = props;
        this.server = server;
        this.num = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.channel.setOpt(3, Boolean.FALSE);
        this.channel.connect("MessageDispatcherSpeedTestGroup");
        try {
            while (this.channel.getNumMessages() > 0) {
                this.channel.receive(10L);
            }
            if (this.server) {
                System.out.println("-- Started as server. Press ctrl-c to kill");
                boolean i = false;
                while (true) {
                    Object obj;
                    if (!((obj = this.channel.receive(0L)) instanceof Message)) {
                        continue;
                    }
                    Message msg = (Message)obj;
                    Message rsp = new Message(msg.getSrc(), null, null);
                    if (++this.received % 1000 == 0) {
                        System.out.println("-- received " + this.received);
                    }
                    this.channel.send(rsp);
                }
            }
            this.sendMessages(this.num);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            this.channel.close();
        }
    }

    void sendMessages(int num) throws Exception {
        int show = num / 10;
        if (show <= 0) {
            show = 1;
        }
        long start = System.currentTimeMillis();
        System.out.println("-- sending " + num + " messages");
        for (int i = 1; i <= num; ++i) {
            Object obj;
            this.channel.send(new Message());
            if (i % show == 0) {
                System.out.println("-- sent " + i);
            }
            while (!((obj = this.channel.receive(0L)) instanceof Message)) {
            }
            ++this.received;
            if (this.received % show != 0) continue;
            System.out.println("-- received response: " + this.received);
        }
        long stop = System.currentTimeMillis();
        this.printStats(stop - start, num);
    }

    void printStats(long total_time, int num) {
        double throughput = (double)num / ((double)total_time / 1000.0);
        System.out.println("time for " + num + " remote calls was " + total_time + ", avg=" + (double)total_time / (double)num + "ms/invocation, " + (long)throughput + " calls/sec");
    }

    public static void main(String[] args) {
        String props = null;
        boolean server = false;
        int num = 1000;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-server".equals(args[i])) {
                server = true;
                continue;
            }
            if ("-num".equals(args[i])) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            SynchronousMessageSpeedTest.help();
            return;
        }
        try {
            SynchronousMessageSpeedTest test = new SynchronousMessageSpeedTest(props, server, num);
            test.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("RpcDispatcherSpeedTest [-help] [-props <props>] [-server] [-num <number of calls>]");
    }
}

