/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class AliasedURLRequestRedirector
implements Filter {
    private static String START_ESCAPED = "%7B$";
    private static String END_ESCAPED = "%7D";
    private static String START = "{$";
    private static String END = "}";
    Map<String, String> replaceMap = new HashMap<String, String>();

    public void init(FilterConfig conf) throws ServletException {
        Enumeration enumeration = conf.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String val = conf.getInitParameter(key);
            this.replaceMap.put(key, val);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(this.createRequestWrapper(req), res);
    }

    private ServletRequest createRequestWrapper(ServletRequest req) {
        return new UrlReplacerWrapper((HttpServletRequest)req, this.replaceMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UrlReplacerWrapper
    extends HttpServletRequestWrapper {
        private final Map<String, String> replaceMap;
        private String pathInfo;
        private String requestUri;
        private StringBuffer requestUrl;

        public UrlReplacerWrapper(HttpServletRequest request, Map<String, String> replaceMap) {
            super(request);
            this.replaceMap = replaceMap;
            this.pathInfo = this.replaceByMap(super.getPathInfo());
            this.requestUri = this.replaceByMap(super.getRequestURI());
            StringBuffer sb = super.getRequestURL();
            this.requestUrl = sb != null ? new StringBuffer(this.replaceByMap(sb.toString())) : null;
        }

        private String replaceByMap(String path) {
            if (path == null) {
                return null;
            }
            String result = path;
            for (String name : this.replaceMap.keySet()) {
                String value = this.replaceMap.get(name);
                if (value == null) continue;
                if (path.indexOf(START) > 0) {
                    result = result.replace(START + name + END, value);
                }
                if (path.indexOf(START_ESCAPED) <= 0) continue;
                result = result.replace(START_ESCAPED + name + END_ESCAPED, value);
            }
            return result;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getRequestURI() {
            return this.requestUri;
        }

        public StringBuffer getRequestURL() {
            return this.requestUrl;
        }
    }
}

