/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.NamingException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.backup.rdbms.DBRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.RestoreTableRule;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDBRestore
extends DBRestore {
    public OracleDBRestore(File storageDir, Connection jdbcConn, Map<String, RestoreTableRule> tables, WorkspaceEntry wsConfig, FileCleaner fileCleaner, DBCleaner dbCleaner) throws NamingException, SQLException, RepositoryConfigurationException {
        super(storageDir, jdbcConn, tables, wsConfig, fileCleaner, dbCleaner);
    }

    @Override
    protected void prepareQueries(boolean isMultiDb) {
        String multiDb = isMultiDb ? "M" : "S";
        String indexName = "JCR_IDX_" + multiDb + "ITEM_PARENT_FK";
        this.addQueries.put(indexName, "CREATE INDEX " + indexName + " ON JCR_" + multiDb + "ITEM(PARENT_ID)");
        this.dropQueries.put(indexName, "DROP INDEX " + indexName);
        indexName = "JCR_IDX_" + multiDb + "ITEM_PARENT";
        this.addQueries.put(indexName, "CREATE UNIQUE INDEX " + indexName + " ON JCR_" + multiDb + "ITEM(CONTAINER_NAME, PARENT_ID, NAME, I_INDEX, I_CLASS, VERSION DESC)");
        this.dropQueries.put(indexName, "DROP INDEX " + indexName);
        indexName = "JCR_IDX_" + multiDb + "ITEM_PARENT_NAME";
        this.addQueries.put(indexName, "CREATE UNIQUE INDEX " + indexName + " ON JCR_" + multiDb + "ITEM(I_CLASS, CONTAINER_NAME, PARENT_ID, NAME, I_INDEX, VERSION DESC)");
        this.dropQueries.put(indexName, "DROP INDEX " + indexName);
        indexName = "JCR_IDX_" + multiDb + "ITEM_PARENT_ID";
        this.addQueries.put(indexName, "CREATE UNIQUE INDEX " + indexName + " ON JCR_" + multiDb + "ITEM(I_CLASS, CONTAINER_NAME, PARENT_ID, ID, VERSION DESC)");
        this.dropQueries.put(indexName, "DROP INDEX " + indexName);
        indexName = "JCR_IDX_" + multiDb + "VALUE_PROPERTY";
        this.addQueries.put(indexName, "CREATE UNIQUE INDEX " + indexName + " ON JCR_" + multiDb + "VALUE(PROPERTY_ID, ORDER_NUM)");
        this.dropQueries.put(indexName, "DROP INDEX " + indexName);
        indexName = "JCR_IDX_" + multiDb + "REF_PROPERTY";
        this.addQueries.put(indexName, "CREATE UNIQUE INDEX " + indexName + " ON JCR_" + multiDb + "REF(PROPERTY_ID, ORDER_NUM)");
        this.dropQueries.put(indexName, "DROP INDEX " + indexName);
        super.prepareQueries(isMultiDb);
    }
}

