/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.InitialProperties;
import org.exoplatform.services.rest.Parameter;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.method.ParameterResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextParameterResolver
extends ParameterResolver<Context> {
    private static final Map<String, CONTEXT_PARAMS> CONTEXT_PARAMETERS_MAP = new HashMap<String, CONTEXT_PARAMS>(4);

    ContextParameterResolver(Context contextParam) {
    }

    @Override
    public Object resolve(Parameter parameter, ApplicationContext context) throws Exception {
        String className = parameter.getParameterClass().getName();
        CONTEXT_PARAMS cp = CONTEXT_PARAMETERS_MAP.get(className);
        if (cp != null) {
            switch (cp) {
                case HTTP_HEADERS: {
                    return context.getHttpHeaders();
                }
                case SECURITY_CONTEXT: {
                    return context.getSecurityContext();
                }
                case REQUEST: {
                    return context.getRequest();
                }
                case URI_INFO: {
                    return context.getUriInfo();
                }
                case PROVIDERS: {
                    return context.getProviders();
                }
                case PROPERTIES: {
                    return context.getInitialProperties();
                }
            }
        }
        return EnvironmentContext.getCurrent().get(parameter.getParameterClass());
    }

    static {
        CONTEXT_PARAMETERS_MAP.put(HttpHeaders.class.getName(), CONTEXT_PARAMS.HTTP_HEADERS);
        CONTEXT_PARAMETERS_MAP.put(SecurityContext.class.getName(), CONTEXT_PARAMS.SECURITY_CONTEXT);
        CONTEXT_PARAMETERS_MAP.put(Request.class.getName(), CONTEXT_PARAMS.REQUEST);
        CONTEXT_PARAMETERS_MAP.put(UriInfo.class.getName(), CONTEXT_PARAMS.URI_INFO);
        CONTEXT_PARAMETERS_MAP.put(Providers.class.getName(), CONTEXT_PARAMS.PROVIDERS);
        CONTEXT_PARAMETERS_MAP.put(InitialProperties.class.getName(), CONTEXT_PARAMS.PROPERTIES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CONTEXT_PARAMS {
        HTTP_HEADERS,
        SECURITY_CONTEXT,
        REQUEST,
        URI_INFO,
        PROVIDERS,
        PROPERTIES;

    }
}

