/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.NamingException;
import org.exoplatform.services.database.utils.ExceptionManagementHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.rdbms.DBRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.RestoreTableRule;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SybaseDBRestore
extends DBRestore {
    private final Boolean isMultiDb;

    public SybaseDBRestore(File storageDir, Connection jdbcConn, Map<String, RestoreTableRule> tables, WorkspaceEntry wsConfig, FileCleaner fileCleaner, DBCleaner dbCleaner) throws NamingException, SQLException, RepositoryConfigurationException {
        super(storageDir, jdbcConn, tables, wsConfig, fileCleaner, dbCleaner);
        this.isMultiDb = tables.entrySet().iterator().next().getValue().getDstMultiDb();
    }

    /*
     * Loose catch block
     */
    @Override
    public void clean() throws BackupException {
        block8: {
            if (!this.jdbcConn.getAutoCommit()) {
                this.jdbcConn.setAutoCommit(true);
            }
            super.clean();
            Object var3_1 = null;
            try {
                this.jdbcConn.setAutoCommit(false);
            }
            catch (SQLException e) {
                LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
            }
            break block8;
            {
                catch (SQLException e) {
                    throw new BackupException(ExceptionManagementHelper.getFullSQLExceptionMessage((SQLException)e), e);
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    this.jdbcConn.setAutoCommit(false);
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void commit() throws BackupException {
        block8: {
            if (!this.jdbcConn.getAutoCommit()) {
                this.jdbcConn.setAutoCommit(true);
            }
            super.commit();
            Object var3_1 = null;
            try {
                this.jdbcConn.setAutoCommit(false);
            }
            catch (SQLException e) {
                LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
            }
            break block8;
            {
                catch (SQLException e) {
                    throw new BackupException(ExceptionManagementHelper.getFullSQLExceptionMessage((SQLException)e), e);
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    this.jdbcConn.setAutoCommit(false);
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void rollback() throws BackupException {
        block8: {
            if (!this.jdbcConn.getAutoCommit()) {
                this.jdbcConn.setAutoCommit(true);
            }
            super.rollback();
            Object var3_1 = null;
            try {
                this.jdbcConn.setAutoCommit(false);
            }
            catch (SQLException e) {
                LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
            }
            break block8;
            {
                catch (SQLException e) {
                    throw new BackupException(ExceptionManagementHelper.getFullSQLExceptionMessage((SQLException)e), e);
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    this.jdbcConn.setAutoCommit(false);
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    @Override
    protected void commitBatch() throws SQLException {
        this.jdbcConn.commit();
    }
}

