/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common.xml;

import java.util.HashMap;
import java.util.Map;
import org.chromattic.common.xml.Handler;
import org.chromattic.common.xml.XMLEmitter;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ElementEmitter
extends XMLEmitter {
    private static final AttributesImpl EMPTY = new AttributesImpl();
    private final String qName;
    private AttributesImpl attrs;
    private Map<String, String> namespaces;

    public ElementEmitter(Handler handler, String qName) {
        super(handler);
        this.qName = qName;
        this.attrs = EMPTY;
    }

    protected void emmitBeginning() throws SAXException {
        this.handler.content.startElement("", "", this.qName, this.attrs);
    }

    protected void emmitEnd() throws SAXException {
        if (this.namespaces != null) {
            for (String prefix : this.namespaces.keySet()) {
                this.handler.content.endPrefixMapping(prefix);
            }
        }
        this.handler.content.endElement("", "", this.qName);
    }

    public ElementEmitter element(String qName) throws SAXException {
        if (qName == null) {
            throw new NullPointerException();
        }
        ElementEmitter child = new ElementEmitter(this.handler, qName);
        this.emitChild(child);
        return child;
    }

    public void content(String data) throws SAXException {
        this.emitChild(null);
        this.handler.content.characters(data.toCharArray(), 0, data.length());
    }

    public void withNamespace(String prefix, String uri) throws SAXException {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        if (this.namespaces.containsKey(prefix)) {
            throw new IllegalStateException("Prefix " + prefix + " already bound to " + uri);
        }
        this.namespaces.put(prefix, uri);
        this.handler.content.startPrefixMapping(prefix, uri);
    }

    public ElementEmitter withAttribute(String qName, String value) {
        this.checkInitial();
        if (qName == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.attrs == EMPTY) {
            this.attrs = new AttributesImpl();
        }
        this.attrs.addAttribute("", "", qName, "", value);
        return this;
    }
}

