/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.AnnotationHandlers;
import com.google.caja.ancillary.jsdoc.Comment;
import com.google.caja.ancillary.jsdoc.JsdocException;
import com.google.caja.ancillary.jsdoc.JsdocMessageType;
import com.google.caja.ancillary.jsdoc.JsdocRewriter;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsLinePreservingPrinter;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Executor;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class Jsdoc {
    private final MessageContext mc;
    private final MessageQueue mq;
    private final AnnotationHandlers handlers;
    private final List<ParseTreeNode> sources = new ArrayList<ParseTreeNode>();
    private final List<Pair<InputSource, Comment>> packageDocs = new ArrayList<Pair<InputSource, Comment>>();
    private final List<Pair<String, String>> initFiles = new ArrayList<Pair<String, String>>();

    public Jsdoc(MessageContext mc, MessageQueue mq) {
        this(new AnnotationHandlers(mc), mc, mq);
    }

    Jsdoc(AnnotationHandlers handlers, MessageContext mc, MessageQueue mq) {
        this.mc = mc;
        this.mq = mq;
        this.handlers = handlers;
    }

    public void addInitFile(String path, String content) {
        this.initFiles.add(Pair.pair(path, content));
    }

    public void addSource(ParseTreeNode source) {
        this.sources.add(source);
    }

    public void addPackage(InputSource pkg, Comment docs) {
        this.packageDocs.add(Pair.pair(pkg, docs));
    }

    public ObjectConstructor extract() throws JsdocException {
        Executor.Input[] rewritten = this.sourceCodeWithDocHooks();
        try {
            LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
            bindings.put("stderr", System.err);
            bindings.put("jsdocPowerBox___", new JsdocPowerBoxSandBoxSafe());
            ObjectConstructor o = Jsdoc.toJson(Executor.Factory.createJsExecutor(rewritten).run(bindings, String.class), this.mq);
            System.err.flush();
            return o;
        }
        catch (Executor.AbnormalExitException ex) {
            throw new JsdocException(new Message((MessageTypeInt)JsdocMessageType.SCRIPT_FAILED_AT_RUNTIME, MessagePart.Factory.valueOf(ex.getScriptTrace())), (Throwable)ex);
        }
        catch (Executor.MalformedSourceException ex) {
            throw new JsdocException(new Message((MessageTypeInt)MessageType.INTERNAL_ERROR, MessagePart.Factory.valueOf("Script not parseable by Rhino")), (Throwable)ex);
        }
        catch (ParseException ex) {
            throw new JsdocException(new Message((MessageTypeInt)MessageType.INTERNAL_ERROR, MessagePart.Factory.valueOf("Failed to parse JSON")), (Throwable)ex);
        }
    }

    private Executor.Input[] sourceCodeWithDocHooks() {
        JsdocRewriter rw = new JsdocRewriter(this.handlers, this.mc, this.mq);
        ArrayList<Executor.Input> hooked = new ArrayList<Executor.Input>();
        for (Pair<String, String> pair : this.initFiles) {
            hooked.add(new Executor.Input(new StringReader((String)pair.b), (String)pair.a));
        }
        try {
            hooked.add(new Executor.Input(Jsdoc.class, "/com/google/caja/plugin/console-stubs.js"));
            hooked.add(new Executor.Input(Jsdoc.class, "jsdoc.js"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (ParseTreeNode parseTreeNode : this.sources) {
            ParseTreeNode rewritten = rw.rewriteFile(parseTreeNode);
            String rewrittenJs = Jsdoc.render(rewritten, parseTreeNode.getFilePosition().source());
            hooked.add(new Executor.Input(new StringReader(rewrittenJs), parseTreeNode.getFilePosition().source().getUri().toString()));
        }
        for (Pair pair : this.packageDocs) {
            ParseTreeNode pkgDocs = rw.rewritePackageDocs((InputSource)pair.a, (Comment)pair.b);
            if (pkgDocs == null) continue;
            String pkgDocsJs = Jsdoc.render(pkgDocs);
            hooked.add(new Executor.Input(new StringReader(pkgDocsJs), ((InputSource)pair.a).getUri().toString()));
        }
        hooked.add(new Executor.Input("jsdoc___.formatJson(jsdoc___.extractDocs())", "jsdoc"));
        return hooked.toArray(new Executor.Input[0]);
    }

    private static ObjectConstructor toJson(String json, MessageQueue mq) throws ParseException {
        InputSource is = new InputSource(URI.create("jsdoc:///output.json"));
        CharProducer cp = CharProducer.Factory.create(new StringReader(json), is);
        JsTokenQueue tq = new JsTokenQueue(new JsLexer(cp), is);
        Parser p = new Parser(tq, mq);
        ObjectConstructor jsonObj = (ObjectConstructor)p.parseExpression(true);
        tq.expectEmpty();
        return jsonObj;
    }

    private static String render(ParseTreeNode node, InputSource is) {
        StringBuilder out = new StringBuilder();
        RenderContext rc = new RenderContext(new JsLinePreservingPrinter(is, new Concatenator(out, null)));
        node.render(rc);
        rc.getOut().noMoreTokens();
        return out.toString();
    }

    private static String render(ParseTreeNode node) {
        StringBuilder out = new StringBuilder();
        RenderContext rc = new RenderContext(node.makeRenderer(out, null));
        node.render(rc);
        rc.getOut().noMoreTokens();
        return out.toString();
    }

    public final class JsdocPowerBoxSandBoxSafe {
        public void addMessage(String messageName, String levelName, String ... content) {
            MessagePart[] parts = new MessagePart[content.length];
            int i = content.length;
            while (--i >= 0) {
                parts[i] = MessagePart.Factory.valueOf(content[i]);
            }
            Jsdoc.this.mq.addMessage((MessageTypeInt)JsdocMessageType.valueOf(messageName), MessageLevel.valueOf(levelName), parts);
        }
    }
}

