/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.ConstantPooler;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Block;
import com.google.caja.util.CajaTestCase;

public class ConstantPoolerTest
extends CajaTestCase {
    public final void testGlobalUsesNotChanged() throws ParseException {
        this.assertOptimized("alert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');", "alert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');");
    }

    public final void testPoolingInFunction() throws ParseException {
        this.assertOptimized("(function () {\nvar $_$__litpool__0$_$ = 'Hello World!';\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\n})()", "(function () {\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\n})()");
    }

    public final void testShorStringsNotPooled() throws ParseException {
        this.assertOptimized("(function () {\nalert('');\nalert('');\nalert('');\n})()", "(function () {\nalert('');\nalert('');\nalert('');\n})()");
    }

    public final void testVarThere() throws ParseException {
        this.assertOptimized("(function () {\nvar $_$__litpool__0$_$ = 'Hello World!', x = 1;\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\n})()", "(function () {\nvar x = 1;\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\n})()");
    }

    public final void testVarsThere() throws ParseException {
        this.assertOptimized("(function () {\nvar $_$__litpool__0$_$ = 'Hello World!', x = 1, y = 2;\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\nalert($_$__litpool__0$_$);\n})()", "(function () {\nvar x = 1, y = 2;\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\nalert('Hello World!');\n})()");
    }

    public final void testMultipleConstants() throws ParseException {
        this.assertOptimized("(function () {\nvar $_$__litpool__0$_$ = 'Hello World!',\n    $_$__litpool__1$_$ = 123456789, x = 1, y = 2;\nalert($_$__litpool__0$_$ != $_$__litpool__1$_$);\nalert($_$__litpool__0$_$ != $_$__litpool__1$_$);\nalert($_$__litpool__0$_$ != $_$__litpool__1$_$);\nalert($_$__litpool__0$_$ != $_$__litpool__1$_$);\nalert($_$__litpool__0$_$ != $_$__litpool__1$_$);\nalert($_$__litpool__0$_$ != $_$__litpool__1$_$);\nalert($_$__litpool__0$_$ != $_$__litpool__1$_$);\n})()", "(function () {\nvar x = 1, y = 2;\nalert('Hello World!' != 123456789);\nalert('Hello World!' != 123456789);\nalert('Hello World!' != 123456789);\nalert('Hello World!' != 123456789);\nalert('Hello World!' != 123456789);\nalert('Hello World!' != 123456789);\nalert('Hello World!' != 123456789);\n})()");
    }

    public final void testObjectConstructors() throws ParseException {
        this.assertOptimized("(function () {\n  var $_$__litpool__0$_$ = 'Kinda loooooooooong';\n  return { 'Loooooooooooooooooong': $_$__litpool__0$_$,\n           'Loooooooooooooooooong': $_$__litpool__0$_$,\n           'Loooooooooooooooooong': $_$__litpool__0$_$,\n           'Loooooooooooooooooong': $_$__litpool__0$_$,\n           'Loooooooooooooooooong': $_$__litpool__0$_$ };\n})()", "(function () {\n  return { 'Loooooooooooooooooong': 'Kinda loooooooooong',\n           'Loooooooooooooooooong': 'Kinda loooooooooong',\n           'Loooooooooooooooooong': 'Kinda loooooooooong',\n           'Loooooooooooooooooong': 'Kinda loooooooooong',\n           'Loooooooooooooooooong': 'Kinda loooooooooong' };\n})()");
    }

    private void assertOptimized(String golden, String input) throws ParseException {
        Block prog = this.js(this.fromString(input));
        ConstantPoolerTest.assertEquals((String)ConstantPoolerTest.render(this.js(this.fromString(golden))), (String)ConstantPoolerTest.render(ConstantPooler.optimize(prog)));
    }
}

