/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.config.ConfigUtil;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IHTML {
    public static final String PREFIX = "ihtml";
    public static final String NAMESPACE = Namespaces.COMMON.forPrefix((String)"ihtml").uri;
    public static final String CALLING_CONTEXT_ATTR = "callingContext";
    public static final HtmlSchema SCHEMA;

    public static Iterable<? extends Element> getPlaceholders(Element container) {
        ArrayList<Element> els = new ArrayList<Element>();
        IHTML.findPlaceholders(container, els);
        return els;
    }

    private static void findPlaceholders(Node n, List<Element> out) {
        if (IHTML.isPh(n) || IHTML.isEph(n)) {
            out.add((Element)n);
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNextSibling()) {
            IHTML.findPlaceholders(c, out);
        }
    }

    public static boolean is(Node n, String localElementName) {
        if (!(n instanceof Element)) {
            return false;
        }
        Element el = (Element)n;
        return localElementName.equals(el.getLocalName()) && NAMESPACE.equals(el.getNamespaceURI());
    }

    public static boolean is(Namespaces ns) {
        return ns.uri == NAMESPACE;
    }

    public static boolean isAttribute(Node n) {
        return IHTML.is(n, "attribute");
    }

    public static Attr getName(Element ihtmlEl) {
        return ihtmlEl.getAttributeNodeNS(NAMESPACE, "name");
    }

    public static boolean isCall(Node n) {
        return IHTML.is(n, "call");
    }

    public static Attr getCallTarget(Element callEl) {
        return callEl.getAttributeNodeNS(NAMESPACE, "ihtml:template");
    }

    public static boolean isDo(Node n) {
        return IHTML.is(n, "do");
    }

    public static Attr getInit(Element doEl) {
        return doEl.getAttributeNodeNS(NAMESPACE, "init");
    }

    public static Attr getVars(Element doEl) {
        return doEl.getAttributeNodeNS(NAMESPACE, "vars");
    }

    public static Attr getWhile(Element doEl) {
        return doEl.getAttributeNodeNS(NAMESPACE, "while");
    }

    public static boolean isDynamic(Node n) {
        return IHTML.is(n, "dynamic");
    }

    public static Attr getExpr(Element dynEl) {
        return dynEl.getAttributeNodeNS(NAMESPACE, "expr");
    }

    public static boolean isElement(Node n) {
        return IHTML.is(n, "element");
    }

    public static boolean isElse(Node n) {
        return IHTML.is(n, "else");
    }

    public static boolean isEph(Node n) {
        return IHTML.is(n, "eph");
    }

    public static boolean isMessage(Node n) {
        return IHTML.is(n, "message");
    }

    public static boolean isPh(Node n) {
        return IHTML.is(n, "ph");
    }

    public static boolean isTemplate(Node n) {
        return IHTML.is(n, "template");
    }

    public static Attr getFormals(Element templateEl) {
        return templateEl.getAttributeNodeNS(NAMESPACE, "formals");
    }

    public static boolean isIhtml(Node n) {
        if (!(n instanceof Element)) {
            return false;
        }
        return NAMESPACE.equals(n.getNamespaceURI());
    }

    public static boolean isSafeIdentifier(String ident) {
        return !ident.endsWith("__") && ParserBase.isJavascriptIdentifier(ident) && !Keyword.isKeyword(ident) && !"arguments".equals(ident);
    }

    public static Iterable<String> identifiers(String idents) {
        return "".equals(idents = idents.trim()) ? Collections.emptyList() : Arrays.asList(idents.trim().split("[ \r\n\t]+"));
    }

    public static Iterable<Element> allOf(Node root, String localName) {
        switch (root.getNodeType()) {
            case 9: {
                return Nodes.nodeListIterable(((Document)root).getElementsByTagNameNS(NAMESPACE, localName), Element.class);
            }
            case 1: {
                return Nodes.nodeListIterable(((Element)root).getElementsByTagNameNS(NAMESPACE, localName), Element.class);
            }
        }
        ArrayList<Element> els = new ArrayList<Element>();
        for (Node node : Nodes.childrenOf(root)) {
            IHTML.appendAllOf(node, "ihtml:" + localName, els);
        }
        return els;
    }

    private static void appendAllOf(Node n, String globalName, List<Element> out) {
        if (n.getNodeType() == 1 && globalName.equals(n.getNodeName())) {
            out.add((Element)n);
        }
        for (Node node : Nodes.childrenOf(n)) {
            IHTML.appendAllOf(node, globalName, out);
        }
    }

    static {
        EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter(System.err), new MessageContext());
        URI elSrc = URI.create("resource:///com/google/caja/plugin/templates/ihtml-elements.json");
        URI attrSrc = URI.create("resource:///com/google/caja/plugin/templates/ihtml-attributes.json");
        try {
            SCHEMA = new HtmlSchema(ConfigUtil.loadWhiteListFromJson(elSrc, ConfigUtil.RESOURCE_RESOLVER, mq), ConfigUtil.loadWhiteListFromJson(attrSrc, ConfigUtil.RESOURCE_RESOLVER, mq));
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
        catch (ParseException ex) {
            mq.getMessages().add(ex.getCajaMessage());
            throw new SomethingWidgyHappenedError(ex);
        }
    }
}

