/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.deployers;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.management.j2ee.JCAResource;
import org.jboss.management.j2ee.deployers.AbstractJSR77Deployer;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCAResourceJSR77Deployer
extends AbstractJSR77Deployer<ManagedConnectionFactoryDeploymentGroup> {
    public JCAResourceJSR77Deployer() {
        super(ManagedConnectionFactoryDeploymentGroup.class);
    }

    @Override
    protected void deployJsr77(MBeanServer server, DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup metaData) throws Throwable {
        ObjectName rarDeployService = null;
        ObjectName cmService = null;
        ObjectName poolService = null;
        Iterable<ObjectName> iter = this.extractComponentObjectNames(server, unit, metaData);
        for (ObjectName oname : iter) {
            String name = oname.getKeyProperty("service");
            if (name.equals("ManagedConnectionFactory") || name.endsWith("DS")) {
                rarDeployService = oname;
                continue;
            }
            if (name.endsWith("CM")) {
                cmService = oname;
                continue;
            }
            if (!name.endsWith("Pool")) continue;
            poolService = oname;
        }
        if (rarDeployService == null || cmService == null) {
            this.log.debug((Object)"Failed to find a service=xxxDS match");
            return;
        }
        try {
            ObjectName rarService = (ObjectName)server.getAttribute(rarDeployService, "OldRarDeployment");
            ObjectName jsr77RAName = JCAResourceJSR77Deployer.getObjectName(unit, rarService.getCanonicalName());
            String resName = rarDeployService.getKeyProperty("name");
            JCAResource.create(server, resName, jsr77RAName, cmService, rarDeployService, poolService);
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to create JCAResource", (Throwable)e);
        }
    }

    @Override
    protected void undeployJsr77(MBeanServer server, DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup metaData) {
        Iterable<ObjectName> mbeans = this.extractComponentObjectNames(server, unit, metaData);
        String resName = this.getDeploymentResName(mbeans);
        JCAResource.destroy(server, resName);
    }

    private String getDeploymentResName(Iterable<ObjectName> mbeans) {
        String resName = null;
        for (ObjectName oname : mbeans) {
            String name = oname.getKeyProperty("service");
            if (!name.equals("ManagedConnectionFactory") && !name.endsWith("DS")) continue;
            ObjectName rarDeployService = oname;
            resName = rarDeployService.getKeyProperty("name");
            break;
        }
        return resName;
    }
}

