/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.bean.history.content;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.manager.history.content.ContentHistoryManager;
import org.rhq.core.clientapi.server.content.ContentDiscoveryReport;
import org.rhq.core.clientapi.server.content.ContentServerService;
import org.rhq.core.clientapi.server.content.ContentServiceResponse;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.composite.PackageVersionMetadataComposite;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentServerServiceImpl
implements ContentServerService {
    private final Log log = LogFactory.getLog(ContentServerServiceImpl.class);
    private ContentHistoryManager historyBean;

    public ContentHistoryManager getHistoryBean() {
        return this.historyBean;
    }

    public void setHistoryBean(ContentHistoryManager historyBean) {
        this.historyBean = historyBean;
    }

    public void completeDeletePackageRequest(RemovePackagesResponse response) {
        this.log.debug((Object)"In completeDeletePackageRequest()");
    }

    public void completeDeployPackageRequest(DeployPackagesResponse response) {
        this.log.debug((Object)"In completeDeployPackageRequest()");
    }

    public void completeRetrievePackageBitsRequest(ContentServiceResponse response, InputStream contentStream) {
        this.log.debug((Object)"In completeRetrievePackageBitsRequest()");
    }

    public long downloadPackageBitsForChildResource(int parentResourceId, String resourceTypeName, PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        return this.downloadPackageBits(packageDetailsKey, outputStream);
    }

    public long downloadPackageBitsGivenResource(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        return this.downloadPackageBits(packageDetailsKey, outputStream);
    }

    public long downloadPackageBitsRangeGivenResource(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream, long startByte, long endByte) {
        this.log.debug((Object)"In downloadPackageBitsRangeGivenResource()");
        return 0L;
    }

    public long getPackageBitsLength(int resourceId, PackageDetailsKey packageDetailsKey) {
        this.log.debug((Object)"In getPackageBitsLength()");
        long bitsLength = 0L;
        String fileName = packageDetailsKey.getName();
        File file = new File(fileName);
        if (file.isFile() && file.exists()) {
            bitsLength = file.length();
        }
        return bitsLength;
    }

    public PageList<PackageVersionMetadataComposite> getPackageVersionMetadata(int resourceId, PageControl pc) {
        this.log.debug((Object)"In getPackageVersionMetadata()");
        return null;
    }

    public String getResourceSubscriptionMD5(int resourceId) {
        this.log.debug((Object)"In getResourceSubscriptionMD5()");
        return null;
    }

    public Set<ResourcePackageDetails> loadDependencies(int requestId, Set<PackageDetailsKey> dependencyPackages) {
        this.log.debug((Object)"In loadDependencies()");
        return null;
    }

    public void mergeDiscoveredPackages(ContentDiscoveryReport report) {
        this.historyBean.addContentHistory(report);
    }

    public boolean preLoadRemoteContent(int i, PackageDetailsKey pdk) {
        return true;
    }

    private long downloadPackageBits(PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        long bitSize;
        this.log.debug((Object)("Downloading package bits for " + packageDetailsKey + "..."));
        String fileName = packageDetailsKey.getName();
        File file = new File(fileName);
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] fileBytes = new byte[(int)file.length()];
            bitSize = inputStream.read(fileBytes);
            inputStream.close();
            outputStream.write(fileBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to download package bits for  child Resource.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Failed to close input stream.", (Throwable)e);
                }
            }
        }
        return bitSize;
    }
}

