/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsMessageProducer;
import org.jboss.resource.adapter.jms.JmsSession;

public class JmsQueueSender
extends JmsMessageProducer
implements QueueSender {
    private static final Logger log = Logger.getLogger(JmsQueueSender.class);
    private boolean trace = log.isTraceEnabled();

    public JmsQueueSender(QueueSender producer, JmsSession session) {
        super((MessageProducer)producer, session);
    }

    public Queue getQueue() throws JMSException {
        return ((QueueSender)this.producer).getQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Queue destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("send " + this + " destination=" + destination + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive));
            }
            this.checkState();
            this.producer.send((Destination)destination, message, deliveryMode, priority, timeToLive);
            if (this.trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Queue destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("send " + this + " destination=" + destination + " message=" + message));
            }
            this.checkState();
            this.producer.send((Destination)destination, message);
            if (this.trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }
}

