/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.PrimitiveObjects;
import org.apache.taglibs.standard.lang.jstl.UnaryOperator;

public class UnaryMinusOperator
extends UnaryOperator {
    public static final UnaryMinusOperator SINGLETON = new UnaryMinusOperator();

    @Override
    public String getOperatorSymbol() {
        return "-";
    }

    @Override
    public Object apply(Object pValue, Object pContext, Logger pLogger) throws ELException {
        if (pValue == null) {
            return PrimitiveObjects.getInteger(0);
        }
        if (pValue instanceof String) {
            if (Coercions.isFloatingPointString(pValue)) {
                double dval = Coercions.coerceToPrimitiveNumber(pValue, Double.class, pLogger).doubleValue();
                return PrimitiveObjects.getDouble(-dval);
            }
            long lval = Coercions.coerceToPrimitiveNumber(pValue, Long.class, pLogger).longValue();
            return PrimitiveObjects.getLong(-lval);
        }
        if (pValue instanceof Byte) {
            return PrimitiveObjects.getByte(-((Byte)pValue).byteValue());
        }
        if (pValue instanceof Short) {
            return PrimitiveObjects.getShort(-((Short)pValue).shortValue());
        }
        if (pValue instanceof Integer) {
            return PrimitiveObjects.getInteger(-((Integer)pValue).intValue());
        }
        if (pValue instanceof Long) {
            return PrimitiveObjects.getLong(-((Long)pValue).longValue());
        }
        if (pValue instanceof Float) {
            return PrimitiveObjects.getFloat(-((Float)pValue).floatValue());
        }
        if (pValue instanceof Double) {
            return PrimitiveObjects.getDouble(-((Double)pValue).doubleValue());
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.UNARY_OP_BAD_TYPE, this.getOperatorSymbol(), (Object)pValue.getClass().getName());
        }
        return PrimitiveObjects.getInteger(0);
    }
}

