/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import java.util.Set;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.RecursivePackageClassFilter;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.version.Version;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.common.jboss.LoaderRepositoryConfigMetaData;
import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarClassLoaderDeployer
extends AbstractSimpleVFSRealDeployer<JBossWebMetaData> {
    private boolean java2ClassLoadingCompliance = false;
    private String filteredPackages;

    public WarClassLoaderDeployer() {
        super(JBossWebMetaData.class);
        this.setStage(DeploymentStages.POST_PARSE);
        this.addInput(ClassLoadingMetaData.class);
        this.setOutput(ClassLoadingMetaData.class);
    }

    public boolean isJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public String getFilteredPackages() {
        return this.filteredPackages;
    }

    public void setFilteredPackages(String pkgs) {
        this.filteredPackages = pkgs;
    }

    public void deploy(VFSDeploymentUnit unit, JBossWebMetaData metaData) throws DeploymentException {
        if (unit.isAttachmentPresent(ClassLoadingMetaData.class)) {
            return;
        }
        String domainName = unit.getName();
        boolean j2seClassLoadingCompliance = this.java2ClassLoadingCompliance;
        org.jboss.metadata.web.jboss.ClassLoadingMetaData webCLMD = metaData.getClassLoading();
        if (webCLMD != null) {
            String repositoryName;
            LoaderRepositoryMetaData lrmd;
            if (webCLMD.wasJava2ClassLoadingComplianceSet()) {
                j2seClassLoadingCompliance = webCLMD.isJava2ClassLoadingCompliance();
            }
            if ((lrmd = webCLMD.getLoaderRepository()) != null && (repositoryName = lrmd.getName()) != null && (repositoryName = repositoryName.trim()) != null) {
                Set configs;
                domainName = repositoryName;
                if (!webCLMD.wasJava2ClassLoadingComplianceSet() && (configs = lrmd.getLoaderRepositoryConfig()) != null && !configs.isEmpty()) {
                    LoaderRepositoryConfigMetaData lrcmd = (LoaderRepositoryConfigMetaData)configs.iterator().next();
                    Properties props = new Properties();
                    String config = lrcmd.getConfig();
                    try {
                        if (config != null) {
                            ByteArrayInputStream bais = new ByteArrayInputStream(config.getBytes());
                            props.load(bais);
                        }
                    }
                    catch (Exception e) {
                        throw DeploymentException.rethrowAsDeploymentException((String)("Error parsing repository config " + config), (Throwable)e);
                    }
                    String java2ParentDelegation = props.getProperty("java2ParentDelegation");
                    if (java2ParentDelegation == null) {
                        java2ParentDelegation = props.getProperty("java2ParentDelegaton", "false");
                    }
                    j2seClassLoadingCompliance = Boolean.valueOf(java2ParentDelegation);
                }
            }
        }
        ClassLoadingMetaData classLoadingMetaData = new ClassLoadingMetaData();
        classLoadingMetaData.setName(unit.getName());
        classLoadingMetaData.setDomain(domainName);
        classLoadingMetaData.setExportAll(ExportAll.NON_EMPTY);
        classLoadingMetaData.setImportAll(true);
        classLoadingMetaData.setVersion((Object)Version.DEFAULT_VERSION);
        classLoadingMetaData.setJ2seClassLoadingCompliance(j2seClassLoadingCompliance);
        RecursivePackageClassFilter filter = null;
        if (this.filteredPackages != null) {
            filter = RecursivePackageClassFilter.createRecursivePackageClassFilterFromString((String)this.filteredPackages);
            classLoadingMetaData.setExcluded((ClassFilter)filter);
        }
        unit.addAttachment(ClassLoadingMetaData.class, (Object)classLoadingMetaData);
    }
}

